/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.boss.Lich;
import twilightforest.entity.projectile.LichBomb;
import twilightforest.entity.projectile.TFThrowable;
import twilightforest.entity.projectile.TwilightWandBolt;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEntities;

public class LichBolt
extends TFThrowable {
    public LichBolt(EntityType<? extends LichBolt> type, Level level) {
        super(type, level);
    }

    public LichBolt(Level level, LivingEntity owner) {
        super((EntityType<? extends TFThrowable>)((EntityType)TFEntities.LICH_BOLT.get()), level, owner);
    }

    public void tick() {
        super.tick();
        this.makeTrail();
    }

    private void makeTrail() {
        float s1 = (this.random.nextFloat() * 0.5f + 0.5f) * 0.17f;
        float s2 = (this.random.nextFloat() * 0.5f + 0.5f) * 0.8f;
        float s3 = (this.random.nextFloat() * 0.5f + 0.5f) * 0.69f;
        this.makeTrail((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)s1, (float)s2, (float)s3), 5);
    }

    public boolean isPickable() {
        return true;
    }

    public float getPickRadius() {
        return 1.0f;
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        super.hurt(damagesource, amount);
        if (!this.level().isClientSide() && damagesource.getEntity() != null) {
            Vec3 vec3d = damagesource.getEntity().getLookAngle();
            this.shoot(vec3d.x(), vec3d.y(), vec3d.z(), 1.5f, 0.1f);
            if (damagesource.getDirectEntity() instanceof LivingEntity) {
                this.setOwner(damagesource.getDirectEntity());
            }
            return true;
        }
        return false;
    }

    protected double getDefaultGravity() {
        return 0.001f;
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ItemStack itemId = new ItemStack((ItemLike)Items.ENDER_PEARL);
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, itemId), this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, this.random.nextDouble() * 0.2, this.random.nextGaussian() * 0.05);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.level().broadcastEntityEvent((Entity)this, (byte)3);
        this.discard();
    }

    protected boolean canHitEntity(Entity target) {
        Lich lich;
        if (target instanceof Lich && ((lich = (Lich)target).getTeleportInvisibility() > 0 || !(this.getOwner() instanceof Player) && lich.getPhase() == 1)) {
            return false;
        }
        return !(target instanceof LichBomb) && !(target instanceof LichBolt) && !(target instanceof TwilightWandBolt);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity hit = result.getEntity();
        if (!this.level().isClientSide()) {
            if (hit instanceof LivingEntity) {
                hit.hurt(TFDamageTypes.getIndirectEntityDamageSource(this.level(), TFDamageTypes.LICH_BOLT, (Entity)this, this.getOwner(), (EntityType)TFEntities.LICH.get()), 6.0f);
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }
}

