/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.boss.Lich;
import twilightforest.entity.projectile.LichBolt;
import twilightforest.entity.projectile.LichBomb;
import twilightforest.init.TFAttributes;
import twilightforest.init.TFItems;

public class LichShadowsGoal
extends Goal {
    private final Lich lich;
    private final float attackRange;

    public LichShadowsGoal(Lich boss, float attackRange) {
        this.lich = boss;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        this.attackRange = attackRange;
    }

    public boolean canUse() {
        return this.lich.getPhase() == 1 && this.lich.tickCount > 20 && this.lich.getTarget() != null;
    }

    public void start() {
        this.lich.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TFItems.TWILIGHT_SCEPTER.get()));
    }

    public void stop() {
        this.lich.despawnClones();
    }

    public void tick() {
        if (!this.lich.isShadowClone()) {
            this.lich.getAllClones().forEach(clone -> {
                clone.setAttackCooldown(this.lich.getAttackCooldown());
                clone.setTeleportInvisibility(this.lich.getTeleportInvisibility());
            });
        }
        if (this.lich.getTeleportInvisibility() > 0) {
            return;
        }
        if (!this.lich.isShadowClone()) {
            LivingEntity targetedEntity = this.lich.getTarget();
            if (this.lich.getAttackCooldown() == 60) {
                if (!this.lich.teleportToNewTarget(targetedEntity, this.attackRange, this)) {
                    this.lich.teleportHome();
                }
            } else if (targetedEntity != null && this.lich.getAttackCooldown() == 0 && this.lich.distanceTo((Entity)targetedEntity) < this.attackRange) {
                this.attack(this.lich);
                for (Lich clone2 : this.lich.getAllClones()) {
                    clone2.setTarget(this.lich.getTarget());
                    this.attack(clone2);
                }
            }
        } else {
            this.checkForMaster();
        }
    }

    protected void attack(Lich lich) {
        if (lich.getNextAttackType() == 0) {
            lich.launchProjectileAt(new LichBolt(lich.level(), (LivingEntity)lich));
        } else {
            lich.launchProjectileAt(new LichBomb(lich.level(), (LivingEntity)lich));
        }
        lich.swing(InteractionHand.MAIN_HAND);
        if (lich.getRandom().nextInt(3) > 0) {
            lich.setNextAttackType(0);
        } else {
            lich.setNextAttackType(1);
        }
        lich.setAttackCooldown(100);
    }

    private void checkForMaster() {
        if (this.lich.getMaster() == null) {
            this.findNewMaster();
        }
        if (this.lich.getMaster() == null || !this.lich.getMaster().isAlive() || this.lich.getMaster().getPhase() != 1) {
            this.lich.discard();
        }
    }

    public void checkAndSpawnClones(LivingEntity targetedEntity) {
        if ((double)this.lich.countMyClones() < this.lich.getAttributeValue((Holder)TFAttributes.CLONE_COUNT)) {
            this.spawnShadowClone(targetedEntity);
        }
    }

    private void spawnShadowClone(LivingEntity targetedEntity) {
        Vec3 cloneSpot = this.lich.findVecInLOSOf((Entity)targetedEntity);
        if (cloneSpot != null) {
            Lich newClone = new Lich(this.lich.level(), this.lich);
            newClone.setPos(cloneSpot.x(), cloneSpot.y(), cloneSpot.z());
            this.lich.level().addFreshEntity((Entity)newClone);
            newClone.setTarget(targetedEntity);
            newClone.setAttackCooldown(60 + this.lich.getRandom().nextInt(3) - this.lich.getRandom().nextInt(3));
            newClone.setItemInHand(InteractionHand.MAIN_HAND, TFItems.TWILIGHT_SCEPTER.toStack());
            newClone.setTeleportInvisibility(this.lich.getTeleportInvisibility());
            this.lich.addClone(newClone.getUUID());
        }
    }

    private void findNewMaster() {
        for (Lich lich : this.getNearbyLiches()) {
            if (lich.isShadowClone() || !lich.wantsNewClone(this.lich)) continue;
            this.lich.setMasterUUID(lich.getUUID());
            lich.addClone(this.lich.getUUID());
            this.lich.setTarget(lich.getTarget());
            break;
        }
    }

    private List<? extends Lich> getNearbyLiches() {
        return this.lich.level().getEntitiesOfClass(this.lich.getClass(), new AABB(this.lich.getX(), this.lich.getY(), this.lich.getZ(), this.lich.getX() + 1.0, this.lich.getY() + 1.0, this.lich.getZ() + 1.0).inflate(32.0, 16.0, 32.0));
    }
}

