/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom.stalactites.entry;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;
import twilightforest.TwilightForestMod;
import twilightforest.data.custom.stalactites.entry.SpeleothemVarietyConfig;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.world.components.structures.util.CodecResourceReloadListener;

public class StalactiteReloadListener
extends CodecResourceReloadListener<SpeleothemVarietyConfig> {
    public static final StalactiteReloadListener INSTANCE = new StalactiteReloadListener();
    public static final String STALACTITE_DIRECTORY = "twilight/stalactites";
    public static final Map<String, SpeleothemVarietyConfig> HILL_CONFIGS = new HashMap<String, SpeleothemVarietyConfig>();
    public static final Map<String, List<Stalactite>> STALACTITES_PER_HILL = new HashMap<String, List<Stalactite>>();
    public static final Map<String, List<Stalactite>> ORE_STALACTITES_PER_HILL = new HashMap<String, List<Stalactite>>();
    public static final Map<String, List<Stalactite>> STALAGMITES_PER_HILL = new HashMap<String, List<Stalactite>>();

    public StalactiteReloadListener() {
        super(STALACTITE_DIRECTORY, SpeleothemVarietyConfig.CODEC);
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
        HILL_CONFIGS.clear();
        ORE_STALACTITES_PER_HILL.clear();
        STALAGMITES_PER_HILL.clear();
        HILL_CONFIGS.clear();
        super.apply(map, manager, profiler);
    }

    @Override
    protected void forLocation(ResourceManager manager, ResourceLocation location, SpeleothemVarietyConfig config) {
        if (!HILL_CONFIGS.containsKey(config.type()) || config.replace()) {
            HILL_CONFIGS.put(config.type(), config);
            if (config.replace()) {
                TwilightForestMod.LOGGER.info("Stalactite Config {} wiped by {}", (Object)config.type(), (Object)location.getNamespace());
            }
        }
        this.populateList(manager, config, config.baseStalactites(), STALACTITES_PER_HILL);
        this.populateList(manager, config, config.oreStalactites(), ORE_STALACTITES_PER_HILL);
        this.populateList(manager, config, config.stalagmites(), STALAGMITES_PER_HILL);
    }

    private void populateList(ResourceManager manager, SpeleothemVarietyConfig config, List<ResourceLocation> rawEntries, Map<String, List<Stalactite>> stalactiteDict) {
        List stalactitesForType = stalactiteDict.computeIfAbsent(config.type(), k -> new ArrayList());
        if (config.replace()) {
            stalactitesForType.clear();
        }
        for (ResourceLocation rl : rawEntries) {
            Optional stalRes = manager.getResource(rl = ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)String.format("%s/%s.json", STALACTITE_DIRECTORY, rl.getPath())));
            if (stalRes.isPresent()) {
                try {
                    BufferedReader stalReader = ((Resource)stalRes.get()).openAsReader();
                    JsonObject stalObject = (JsonObject)GsonHelper.fromJson((Gson)this.gson, (Reader)stalReader, JsonObject.class);
                    Stalactite stalactite = (Stalactite)Stalactite.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)stalObject).resultOrPartial(arg_0 -> ((Logger)TwilightForestMod.LOGGER).error(arg_0)).orElseThrow();
                    stalactitesForType.add(stalactite);
                    TwilightForestMod.LOGGER.debug("Loaded Stalactite {} for config {}", (Object)rl, (Object)config.type());
                }
                catch (IOException | RuntimeException e) {
                    TwilightForestMod.LOGGER.error("Failed to parse stalactite entry {} in file {}", (Object)rl, (Object)config, (Object)e);
                }
                continue;
            }
            TwilightForestMod.LOGGER.error("Could not find stalactite entry for {}", (Object)rl);
        }
    }
}

