/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.jei.categories;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import twilightforest.TwilightForestMod;
import twilightforest.compat.jei.JEICompat;
import twilightforest.compat.jei.renderers.EntityRenderer;
import twilightforest.compat.jei.util.TransformationRecipe;
import twilightforest.init.TFItems;

public class TransformationPowderCategory
implements IRecipeCategory<TransformationRecipe> {
    public static final RecipeType<TransformationRecipe> TRANSFORMATION = RecipeType.create((String)"twilightforest", (String)"transformation_powder", TransformationRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrow;
    private final IDrawable doubleArrow;
    private final Component localizedName;
    private final EntityRenderer entityRenderer = new EntityRenderer(32);

    public TransformationPowderCategory(IGuiHelper helper) {
        ResourceLocation location = TwilightForestMod.getGuiTexture("transformation_jei.png");
        this.background = helper.createDrawable(location, 0, 0, 116, 54);
        this.arrow = helper.createDrawable(location, 116, 0, 23, 15);
        this.doubleArrow = helper.createDrawable(location, 116, 16, 23, 15);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Item)TFItems.TRANSFORMATION_POWDER.get()).getDefaultInstance());
        this.localizedName = Component.translatable((String)"gui.twilightforest.transformation_jei");
    }

    public RecipeType<TransformationRecipe> getRecipeType() {
        return TRANSFORMATION;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(TransformationRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        if (recipe.isReversible()) {
            this.doubleArrow.draw(graphics, 46, 19);
        } else {
            this.arrow.draw(graphics, 46, 19);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TransformationRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 8, 11).setCustomRenderer(JEICompat.ENTITY_TYPE, (IIngredientRenderer)this.entityRenderer).addIngredient(JEICompat.ENTITY_TYPE, (Object)recipe.input());
        SpawnEggItem inputEgg = DeferredSpawnEggItem.byId(recipe.input().type());
        if (inputEgg != null) {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(new ItemStack((ItemLike)inputEgg));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 11).setCustomRenderer(JEICompat.ENTITY_TYPE, (IIngredientRenderer)this.entityRenderer).addIngredient(JEICompat.ENTITY_TYPE, (Object)recipe.output());
        SpawnEggItem outputEgg = DeferredSpawnEggItem.byId(recipe.output().type());
        if (outputEgg != null) {
            builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(new ItemStack((ItemLike)outputEgg));
        }
    }
}

