/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.emi.recipes;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.compat.emi.EmiEntityWidget;
import twilightforest.compat.emi.TFEmiCompat;

public class EmiTransformationPowderRecipe
implements EmiRecipe {
    private static final int WIDTH = 116;
    private static final int HEIGHT = 46;
    public static final ResourceLocation TEXTURES = TwilightForestMod.getGuiTexture("transformation_jei.png");
    public static final EmiTexture BACKGROUND = new EmiTexture(TEXTURES, 0, 0, 116, 46);
    public static final EmiTexture SINGLE_ARROW = new EmiTexture(TEXTURES, 116, 0, 23, 15);
    public static final EmiTexture DOUBLE_ARROW = new EmiTexture(TEXTURES, 116, 16, 23, 15);
    private final EntityType<?> input;
    private final EntityType<?> output;
    private final boolean isReversible;
    public final EmiTexture arrow;

    public EmiTransformationPowderRecipe(EntityType<?> input, EntityType<?> output, boolean reversible) {
        this.input = input;
        this.output = output;
        this.isReversible = reversible;
        this.arrow = reversible ? DOUBLE_ARROW : SINGLE_ARROW;
    }

    public EmiRecipeCategory getCategory() {
        return TFEmiCompat.TRANSFORMATION;
    }

    @Nullable
    public ResourceLocation getId() {
        return null;
    }

    public List<EmiIngredient> getInputs() {
        ArrayList<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
        SpawnEggItem inputEgg = DeferredSpawnEggItem.byId(this.input);
        SpawnEggItem outputEgg = DeferredSpawnEggItem.byId(this.output);
        if (inputEgg != null) {
            inputs.add((EmiIngredient)EmiStack.of((ItemLike)inputEgg));
            if (this.isReversible && outputEgg != null) {
                inputs.add((EmiIngredient)EmiStack.of((ItemLike)outputEgg));
            }
        }
        return inputs;
    }

    public List<EmiStack> getOutputs() {
        ArrayList<EmiStack> outputs = new ArrayList<EmiStack>();
        SpawnEggItem inputEgg = DeferredSpawnEggItem.byId(this.input);
        SpawnEggItem outputEgg = DeferredSpawnEggItem.byId(this.output);
        if (outputEgg != null) {
            outputs.add(EmiStack.of((ItemLike)outputEgg));
            if (this.isReversible && inputEgg != null) {
                outputs.add(EmiStack.of((ItemLike)inputEgg));
            }
        }
        return outputs;
    }

    public int getDisplayWidth() {
        return 116;
    }

    public int getDisplayHeight() {
        return 46;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0);
        widgets.add((Widget)new EmiEntityWidget(this.input, 7, 12, 32));
        widgets.addTexture(this.arrow, 46, 19);
        widgets.add((Widget)new EmiEntityWidget(this.output, 75, 12, 32));
    }

    public boolean supportsRecipeTree() {
        return false;
    }
}

