/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.entity.monster.UpperGoblinKnight;

public class UpperGoblinKnightModel
extends HumanoidModel<UpperGoblinKnight> {
    private final ModelPart breastplate;
    private final ModelPart shield;

    public UpperGoblinKnightModel(ModelPart root) {
        super(root);
        this.breastplate = this.body.getChild("breastplate");
        this.shield = this.leftArm.getChild("shield");
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? UpperGoblinKnightModel.createJappaModel() : UpperGoblinKnightModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition hat = partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        hat.addOrReplaceChild("helmet", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -11.0f, -3.5f, 7.0f, 11.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition rightHorn = hat.addOrReplaceChild("right_horn_1", CubeListBuilder.create().texOffs(28, 0).addBox(-6.0f, -1.5f, -1.5f, 7.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)-3.5f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.2617994f, (float)0.17453292f));
        rightHorn.addOrReplaceChild("right_horn_2", CubeListBuilder.create().texOffs(28, 6).addBox(-3.0f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.17453292f));
        PartDefinition leftHorn = hat.addOrReplaceChild("left_horn_1", CubeListBuilder.create().mirror().texOffs(28, 0).addBox(-1.0f, -1.5f, -1.5f, 7.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)3.5f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)-0.2617994f, (float)-0.17453292f));
        leftHorn.addOrReplaceChild("left_horn_2", CubeListBuilder.create().mirror().texOffs(28, 6).addBox(0.0f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.17453292f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 18).addBox(-5.5f, 0.0f, -2.0f, 11.0f, 8.0f, 4.0f).texOffs(30, 24).addBox(-6.5f, 0.0f, -2.0f, 1.0f, 4.0f, 4.0f).texOffs(30, 24).addBox(5.5f, 0.0f, -2.0f, 1.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        body.addOrReplaceChild("breastplate", CubeListBuilder.create().texOffs(64, 0).addBox(-6.5f, 0.0f, -3.0f, 13.0f, 12.0f, 6.0f), PartPose.offset((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(44, 16).addBox(-4.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-6.5f, (float)14.0f, (float)0.0f));
        rightArm.addOrReplaceChild("spear", CubeListBuilder.create().texOffs(108, 0).addBox(-1.0f, -19.0f, -1.0f, 2.0f, 40.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)8.5f, (float)0.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(44, 16).addBox(0.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)6.5f, (float)14.0f, (float)0.0f));
        leftArm.addOrReplaceChild("shield", CubeListBuilder.create().texOffs(63, 36).addBox(-6.0f, -6.0f, -2.0f, 12.0f, 20.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(30, 16).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 4.0f, 4.0f), PartPose.offset((float)-4.0f, (float)20.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(30, 16).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 4.0f, 4.0f), PartPose.offset((float)4.0f, (float)20.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(28, 0).addBox(-8.0f, -14.0f, -1.9f, 16.0f, 14.0f, 2.0f).texOffs(116, 0).addBox(-6.0f, -12.0f, -0.9f, 4.0f, 2.0f, 2.0f).texOffs(116, 4).addBox(2.0f, -12.0f, -1.0f, 4.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        head.addOrReplaceChild("helm", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 11.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 18).addBox(-5.5f, 0.0f, -2.0f, 11.0f, 8.0f, 4.0f), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        body.addOrReplaceChild("breastplate", CubeListBuilder.create().texOffs(64, 0).addBox(-6.5f, 0.0f, -3.0f, 13.0f, 12.0f, 6.0f), PartPose.offset((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(44, 16).addBox(-4.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offsetAndRotation((float)-5.5f, (float)14.0f, (float)0.0f, (float)-2.3876104f, (float)0.0f, (float)0.10000737f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(44, 32).addBox(0.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offsetAndRotation((float)5.5f, (float)14.0f, (float)0.0f, (float)0.20001474f, (float)0.0f, (float)0.10000737f));
        rightArm.addOrReplaceChild("spear", CubeListBuilder.create().texOffs(108, 0).addBox(-1.0f, -19.0f, -1.0f, 2.0f, 40.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)8.5f, (float)0.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        leftArm.addOrReplaceChild("shield", CubeListBuilder.create().texOffs(63, 36).addBox(-6.0f, -6.0f, -2.0f, 12.0f, 20.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)0.0f, (float)6.083185f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(30, 24).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 4.0f, 4.0f), PartPose.offset((float)-4.0f, (float)20.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(30, 16).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 4.0f, 4.0f), PartPose.offset((float)4.0f, (float)20.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(UpperGoblinKnight entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean hasShield = entity.hasShield();
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.zRot = 0.0f;
        this.hat.yRot = this.head.yRot;
        this.hat.xRot = this.head.xRot;
        this.hat.zRot = this.head.zRot;
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        float leftConstraint = hasShield ? 0.2f : limbSwingAmount;
        this.leftArm.zRot = entity.isShieldDisabled() ? Mth.cos((float)((float)entity.tickCount * 3.25f)) * (float)Math.PI * 0.4f * ((float)Math.PI / 180) - 0.4f : 0.0f;
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * leftConstraint * 0.5f;
        this.rightArm.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        if (this.riding) {
            this.rightArm.xRot -= 0.62831855f;
            this.leftArm.xRot -= 0.62831855f;
            this.rightLeg.xRot = 0.0f;
            this.leftLeg.xRot = 0.0f;
        }
        if (this.leftArmPose != HumanoidModel.ArmPose.EMPTY) {
            this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.31415927f;
        }
        this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.31415927f;
        this.rightArm.xRot -= 2.0734513f;
        if (entity.heavySpearTimer > 0) {
            this.rightArm.xRot -= this.getArmRotationDuringSwing(60.0f - (float)entity.heavySpearTimer) * ((float)Math.PI / 180);
        }
        this.rightArm.yRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        AnimationUtils.bobArms((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)ageInTicks);
        this.leftArm.zRot = -this.leftArm.zRot;
        this.shield.xRot = (float)Math.PI * 2 - this.leftArm.xRot;
        this.breastplate.visible = entity.hasArmor();
        this.shield.visible = entity.hasShield();
    }

    private float getArmRotationDuringSwing(float attackTime) {
        if (attackTime <= 10.0f) {
            return attackTime;
        }
        if (attackTime > 10.0f && attackTime <= 30.0f) {
            return 10.0f;
        }
        if (attackTime > 30.0f && attackTime <= 33.0f) {
            return (attackTime - 30.0f) * -8.0f + 10.0f;
        }
        if (attackTime > 33.0f && attackTime <= 50.0f) {
            return -15.0f;
        }
        if (attackTime > 50.0f && attackTime <= 60.0f) {
            return (10.0f - (attackTime - 50.0f)) * -1.5f;
        }
        return 0.0f;
    }
}

