/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import twilightforest.entity.monster.HostileWolf;

public class HostileWolfModel<T extends HostileWolf>
extends AgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private final ModelPart upperBody;

    public HostileWolfModel(ModelPart root) {
        this(RenderType::entityCutoutNoCull, root);
    }

    public HostileWolfModel(Function<ResourceLocation, RenderType> type, ModelPart root) {
        super(type, false, 5.0f, 2.0f, 2.0f, 2.0f, 24.0f);
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.upperBody = root.getChild("upper_body");
        this.rightHindLeg = root.getChild("right_hind_leg");
        this.leftHindLeg = root.getChild("left_hind_leg");
        this.rightFrontLeg = root.getChild("right_front_leg");
        this.leftFrontLeg = root.getChild("left_front_leg");
        this.tail = root.getChild("tail");
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.tail, (Object)this.upperBody);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.tail.yRot = entity.isAggressive() ? 0.0f : Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.body.setPos(0.0f, 14.0f, 2.0f);
        this.body.xRot = 1.5707964f;
        this.upperBody.setPos(-1.0f, 14.0f, -3.0f);
        this.upperBody.xRot = this.body.xRot;
        this.tail.setPos(-1.0f, 12.0f, 8.0f);
        this.rightHindLeg.setPos(-2.5f, 16.0f, 7.0f);
        this.leftHindLeg.setPos(0.5f, 16.0f, 7.0f);
        this.rightFrontLeg.setPos(-2.5f, 16.0f, -4.0f);
        this.leftFrontLeg.setPos(0.5f, 16.0f, -4.0f);
        this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.tail.xRot = ageInTicks;
    }
}

