/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.block.patch;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import twilightforest.block.PatchBlock;
import twilightforest.init.TFBlocks;

public record PatchModel(TextureAtlasSprite texture, boolean shaggify) implements BakedModel
{
    private static final FaceBakery BAKERY = new FaceBakery();

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource random) {
        if (state == null) {
            return this.getQuads(false, false, false, false, random);
        }
        return this.getQuads((Boolean)state.getValue((Property)PatchBlock.NORTH), (Boolean)state.getValue((Property)PatchBlock.EAST), (Boolean)state.getValue((Property)PatchBlock.SOUTH), (Boolean)state.getValue((Property)PatchBlock.WEST), random);
    }

    private List<BakedQuad> getQuads(boolean north, boolean east, boolean south, boolean west, RandomSource posRandom) {
        int minX;
        int innerZ;
        int maxZ;
        int minZ;
        int num3;
        int num2;
        int num1;
        int num0;
        long seed;
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        BoundingBox bb = PatchBlock.AABBFromRandom(posRandom);
        this.quadsFromAABB(list, west ? 0.0f : (float)bb.minX(), bb.minY(), north ? 0.0f : (float)bb.minZ(), east ? 16.0f : (float)bb.maxX(), bb.maxY(), south ? 16.0f : (float)bb.maxZ());
        if (!this.shaggify) {
            return ImmutableList.copyOf(list);
        }
        long westSeed = posRandom.nextLong();
        long eastSeed = posRandom.nextLong();
        long northSeed = posRandom.nextLong();
        long southSeed = posRandom.nextLong();
        int minY = bb.minY();
        int maxY = bb.maxY();
        if (!west) {
            seed = westSeed;
            seed = seed * seed * 42317861L + seed * 7L;
            num0 = (int)(seed >> 12 & 3L) + 1;
            num1 = (int)(seed >> 15 & 3L) + 1;
            num2 = (int)(seed >> 18 & 3L) + 1;
            num3 = (int)(seed >> 21 & 3L) + 1;
            minZ = bb.minZ() + num0;
            maxZ = bb.maxZ();
            if (maxZ - (num1 + num2 + num3) > minZ) {
                innerZ = bb.maxZ() - num2;
                this.quadsFromAABB(list, bb.minX() - 1, minY, minZ, bb.minX(), maxY, minZ + num1);
                this.quadsFromAABB(list, bb.minX() - 1, minY, innerZ - num3, bb.minX(), maxY, innerZ);
            } else {
                this.quadsFromAABB(list, bb.minX() - 1, minY, minZ, bb.minX(), maxY, maxZ - num2);
            }
        }
        if (!east) {
            seed = eastSeed;
            seed = seed * seed * 42317861L + seed * 17L;
            num0 = (int)(seed >> 12 & 3L) + 1;
            num1 = (int)(seed >> 15 & 3L) + 1;
            num2 = (int)(seed >> 18 & 3L) + 1;
            num3 = (int)(seed >> 21 & 3L) + 1;
            minZ = bb.minZ() + num0;
            maxZ = bb.maxZ();
            if (maxZ - (num1 + num2 + num3) > minZ) {
                innerZ = maxZ - num2;
                this.quadsFromAABB(list, bb.maxX(), minY, minZ, bb.maxX() + 1, maxY, minZ + num1);
                this.quadsFromAABB(list, bb.maxX(), minY, innerZ - num3, bb.maxX() + 1, maxY, innerZ);
            } else {
                this.quadsFromAABB(list, bb.maxX(), minY, minZ, bb.maxX() + 1, maxY, maxZ - num2);
            }
        }
        if (!north) {
            seed = northSeed;
            seed = seed * seed * 42317861L + seed * 23L;
            num0 = (int)(seed >> 12 & 3L) + 1;
            num1 = (int)(seed >> 15 & 3L) + 1;
            num2 = (int)(seed >> 18 & 3L) + 1;
            num3 = (int)(seed >> 21 & 3L) + 1;
            minX = bb.minX() + num0;
            int innerX = minX + num1;
            int maxX = bb.maxX() - num2;
            this.quadsFromAABB(list, minX, minY, bb.minZ() - 1, innerX, maxY, bb.minZ());
            this.quadsFromAABB(list, maxX - num3, minY, bb.minZ() - 1, maxX, maxY, bb.minZ());
        }
        if (!south) {
            seed = southSeed;
            seed = seed * seed * 42317861L + seed * 11L;
            num0 = (int)(seed >> 12 & 3L) + 1;
            num1 = (int)(seed >> 15 & 3L) + 1;
            num2 = (int)(seed >> 18 & 3L) + 1;
            num3 = (int)(seed >> 21 & 3L) + 1;
            minX = bb.minX() + num0;
            int maxX = bb.maxX() - num2;
            this.quadsFromAABB(list, minX, minY, bb.maxZ(), minX + num1, maxY, bb.maxZ() + 1);
            this.quadsFromAABB(list, maxX - num3, minY, bb.maxZ(), maxX, maxY, bb.maxZ() + 1);
        }
        return ImmutableList.copyOf(list);
    }

    private void quadsFromAABB(List<BakedQuad> quads, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        quads.add(this.quadFromVectors(Direction.UP, minX, minY, minZ, maxX, maxY, maxZ));
        quads.add(this.quadFromVectors(Direction.NORTH, minX, minY, minZ, maxX, maxY, maxZ));
        quads.add(this.quadFromVectors(Direction.EAST, minX, minY, minZ, maxX, maxY, maxZ));
        quads.add(this.quadFromVectors(Direction.SOUTH, minX, minY, minZ, maxX, maxY, maxZ));
        quads.add(this.quadFromVectors(Direction.WEST, minX, minY, minZ, maxX, maxY, maxZ));
        quads.add(this.quadFromVectors(Direction.DOWN, minX, minY, minZ, maxX, maxY, maxZ));
    }

    private BakedQuad quadFromVectors(Direction direction, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        String string = this.texture.atlasLocation().toString();
        BlockElementFace face = new BlockElementFace(null, 0, string, switch (direction) {
            case Direction.NORTH -> new BlockFaceUV(new float[]{maxX, minZ + 1.0f, minX, minZ}, 0);
            case Direction.EAST -> new BlockFaceUV(new float[]{maxX, minZ, maxX - 1.0f, maxZ}, 90);
            case Direction.SOUTH -> new BlockFaceUV(new float[]{minX, maxZ, maxX, maxZ - 1.0f}, 0);
            case Direction.WEST -> new BlockFaceUV(new float[]{minX, maxZ, minX + 1.0f, minZ}, 90);
            default -> new BlockFaceUV(new float[]{minX, minZ, maxX, maxZ}, 0);
        });
        return BAKERY.bakeQuad(new Vector3f(minX, minY, minZ), new Vector3f(maxX, maxY, maxZ), face, this.texture, direction, (ModelState)new SimpleModelState(Transformation.identity()), null, true);
    }

    public boolean useAmbientOcclusion() {
        return false;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.texture;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        if (state.is(TFBlocks.CLOVER_PATCH)) {
            return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutout()});
        }
        return super.getRenderTypes(state, rand, data);
    }
}

