/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFBlocks;

public class GrowingBeanstalkBlockEntity
extends BlockEntity {
    private int ticker;
    private int layer;
    private boolean isAreaClearEnough = true;
    private int nextLeafY;
    private int yOffset;
    private float cScale;
    private float rScale;
    private int maxY;
    private int blocksSkipped;

    public GrowingBeanstalkBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.BEANSTALK_GROWER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GrowingBeanstalkBlockEntity te) {
        ++te.ticker;
        if (te.ticker == 1) {
            te.nextLeafY = pos.getY() + 10 + level.getRandom().nextInt(10);
            te.yOffset = level.getRandom().nextInt(100);
            te.cScale = level.getRandom().nextFloat() * 0.25f + 0.125f;
            te.rScale = level.getRandom().nextFloat() * 0.25f + 0.125f;
            te.maxY = Math.max(pos.getY() + 100, 175);
        }
        if (level.isClientSide()) {
            if (te.ticker < 100) {
                for (int i = 0; i < 20; ++i) {
                    float x = (float)pos.getX() + level.getRandom().nextFloat() + (float)(level.getRandom().nextInt(5) * (level.getRandom().nextBoolean() ? -1 : 1));
                    float z = (float)pos.getZ() + level.getRandom().nextFloat() + (float)(level.getRandom().nextInt(5) * (level.getRandom().nextBoolean() ? -1 : 1));
                    BlockState underState = level.getBlockState(BlockPos.containing((double)x, (double)pos.below().getY(), (double)z));
                    if (!underState.isSolid()) continue;
                    level.addAlwaysVisibleParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, underState), (double)x, (double)pos.getY(), (double)z, 0.0, 0.0, 0.0);
                }
            }
        } else if (te.ticker > 100 && te.ticker % 2 == 0) {
            int layerYPos = pos.getY() + te.layer;
            if (te.isAreaClearEnough && layerYPos < te.maxY) {
                float x = pos.getX();
                float z = pos.getZ();
                float radius = 4.0f + Mth.sin((float)((float)(pos.getY() + te.yOffset) * te.rScale)) * 3.0f;
                x -= Mth.sin((float)((float)(pos.getY() + te.yOffset) * te.cScale)) * radius;
                z -= Mth.cos((float)((float)(pos.getY() + te.yOffset) * te.cScale)) * radius;
                radius = 5.0f + Mth.sin((float)((float)(layerYPos + te.yOffset) * te.rScale)) * 2.5f;
                float cx = x + Mth.sin((float)((float)(layerYPos + te.yOffset) * te.cScale)) * radius;
                float cz = z + Mth.cos((float)((float)(layerYPos + te.yOffset) * te.cScale)) * radius;
                float stalkThickness = 2.5f;
                if (te.maxY - layerYPos < 5) {
                    stalkThickness *= (float)(te.maxY - layerYPos) / 5.0f;
                }
                int minX = Mth.floor((float)(x - radius - stalkThickness));
                int maxX = Mth.ceil((float)(x + radius + stalkThickness));
                int minZ = Mth.floor((float)(z - radius - stalkThickness));
                int maxZ = Mth.ceil((float)(z + radius + stalkThickness));
                for (int dx = minX; dx < maxX && te.isAreaClearEnough; ++dx) {
                    for (int dz = minZ; dz < maxZ && te.isAreaClearEnough; ++dz) {
                        float circle = ((float)dx - cx) * ((float)dx - cx) + ((float)dz - cz) * ((float)dz - cz);
                        if (!(circle < stalkThickness * stalkThickness)) continue;
                        te.isAreaClearEnough = te.tryToPlaceStalk(level, new BlockPos(dx, layerYPos, dz), true);
                        if (!(circle < stalkThickness)) continue;
                        te.tryToPlaceStalk(level, new BlockPos(dx, layerYPos + 1, dz), false);
                        if (!(circle < stalkThickness / 2.0f)) continue;
                        te.tryToPlaceStalk(level, new BlockPos(dx, layerYPos + 2, dz), false);
                    }
                }
                te.blocksSkipped = 0;
                if (layerYPos == te.nextLeafY) {
                    boolean wasAnEvenNumber = te.nextLeafY % 2 == 0;
                    float v = radius + (wasAnEvenNumber ? stalkThickness : -stalkThickness);
                    int lx = (int)(x + Mth.sin((float)((float)(layerYPos + te.yOffset) * te.cScale)) * v);
                    int lz = (int)(z + Mth.cos((float)((float)(layerYPos + te.yOffset) * te.cScale)) * v);
                    te.placeLeaves(level, new BlockPos(lx, layerYPos, lz));
                    te.nextLeafY = layerYPos + 5 + level.getRandom().nextInt(10);
                    if (te.nextLeafY % 2 == 0 == wasAnEvenNumber) {
                        ++te.nextLeafY;
                    }
                }
                ++te.layer;
            } else {
                level.setBlockAndUpdate(pos, ((RotatedPillarBlock)TFBlocks.HUGE_STALK.get()).defaultBlockState());
                level.removeBlockEntity(pos);
            }
        }
    }

    private void placeLeaves(Level level, BlockPos pos) {
        int dz;
        int dx;
        level.setBlockAndUpdate(pos, ((RotatedPillarBlock)TFBlocks.HUGE_STALK.get()).defaultBlockState());
        for (dx = -1; dx <= 1; ++dx) {
            for (dz = -1; dz <= 1; ++dz) {
                int distance = Math.abs(dx) + Math.abs(dz) + 1;
                this.tryToPlaceLeaves(level, pos.offset(dx, -1, dz), distance);
                this.tryToPlaceLeaves(level, pos.offset(dx, 1, dz), distance);
            }
        }
        for (dx = -2; dx <= 2; ++dx) {
            for (dz = -2; dz <= 2; ++dz) {
                if ((dx == 2 || dx == -2) && (dz == 2 || dz == -2)) continue;
                this.tryToPlaceLeaves(level, pos.offset(dx, 0, dz), Math.max(Math.abs(dx) + Math.abs(dz), 1));
            }
        }
    }

    private boolean tryToPlaceStalk(Level level, BlockPos pos, boolean checkBlocked) {
        BlockState state = level.getBlockState(pos);
        if (state.isAir() || state.canBeReplaced() && !state.is(TFBlocks.BEANSTALK_GROWER) || state.isAir() || state.is(BlockTags.LEAVES) || state.is(TFBlocks.FLUFFY_CLOUD)) {
            level.setBlockAndUpdate(pos, ((RotatedPillarBlock)TFBlocks.HUGE_STALK.get()).defaultBlockState());
            if (pos.getY() > 150) {
                for (int i = 0; i < 7; ++i) {
                    if (!level.getBlockState(pos.relative(Direction.UP, i)).is(TFBlocks.WISPY_CLOUD) && !level.getBlockState(pos.relative(Direction.UP, i)).is(TFBlocks.FLUFFY_CLOUD)) continue;
                    level.setBlockAndUpdate(pos.relative(Direction.UP, i), Blocks.AIR.defaultBlockState());
                }
            }
            return true;
        }
        if (!state.is(TFBlocks.HUGE_STALK) && checkBlocked) {
            ++this.blocksSkipped;
        }
        return this.blocksSkipped < 15;
    }

    private void tryToPlaceLeaves(Level level, BlockPos pos, int distance) {
        BlockState state = level.getBlockState(pos);
        if (state.isAir() || state.is(BlockTags.LEAVES)) {
            level.setBlock(pos, (BlockState)((Block)TFBlocks.BEANSTALK_LEAVES.get()).defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(distance)), 2);
        }
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putInt("ticker", this.ticker);
        compoundTag.putInt("layer", this.layer);
        compoundTag.putBoolean("isAreaClearEnough", this.isAreaClearEnough);
        compoundTag.putInt("nextLeafY", this.nextLeafY);
        compoundTag.putInt("yOffset", this.yOffset);
        compoundTag.putFloat("cScale", this.cScale);
        compoundTag.putFloat("rScale", this.rScale);
        compoundTag.putInt("maxY", this.maxY);
        compoundTag.putInt("blocksSkipped", this.blocksSkipped);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.ticker = compoundTag.getInt("ticker");
        this.layer = compoundTag.getInt("layer");
        this.isAreaClearEnough = compoundTag.getBoolean("isAreaClearEnough");
        this.nextLeafY = compoundTag.getInt("nextLeafY");
        this.yOffset = compoundTag.getInt("yOffset");
        this.cScale = compoundTag.getFloat("cScale");
        this.rScale = compoundTag.getFloat("rScale");
        this.maxY = compoundTag.getInt("maxY");
        this.blocksSkipped = compoundTag.getInt("blocksSkipped");
    }

    public boolean isBeanstalkRumbling() {
        return this.ticker < 110;
    }
}

