/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.TwilightForestMod;
import twilightforest.advancements.SimpleAdvancementTrigger;
import twilightforest.block.TrophyBlock;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFAdvancements;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStats;
import twilightforest.util.PlayerHelper;
import twilightforest.util.landmarks.LandmarkUtil;

public class TrophyPedestalBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape BOTTOM = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);
    private static final VoxelShape MID = Block.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private static final VoxelShape TOP = Block.box((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape CORNER1 = Block.box((double)1.0, (double)12.0, (double)1.0, (double)4.0, (double)13.0, (double)4.0);
    private static final VoxelShape CORNER2 = Block.box((double)12.0, (double)12.0, (double)1.0, (double)15.0, (double)13.0, (double)4.0);
    private static final VoxelShape CORNER3 = Block.box((double)1.0, (double)12.0, (double)12.0, (double)4.0, (double)13.0, (double)15.0);
    private static final VoxelShape CORNER4 = Block.box((double)12.0, (double)12.0, (double)12.0, (double)15.0, (double)13.0, (double)15.0);
    private static final VoxelShape FINAL = Shapes.or((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{MID, TOP, CORNER1, CORNER2, CORNER3, CORNER4});

    public TrophyPedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            accessor.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, facing, facingState, accessor, currentPos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return FINAL;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        level.updateNeighbourForOutputSignal(pos, (Block)this);
        if (level.isClientSide() || ((Boolean)state.getValue((Property)ACTIVE)).booleanValue() || !this.isTrophyOnTop(level, pos)) {
            return;
        }
        if (LandmarkUtil.isProgressionEnforced(level)) {
            if (this.areNearbyPlayersEligible(level, pos)) {
                this.doPedestalEffect(level, pos, state);
            }
            this.warnIneligiblePlayers(level, pos);
        } else {
            this.doPedestalEffect(level, pos, state);
        }
        this.rewardNearbyPlayers(level, pos);
    }

    private boolean isTrophyOnTop(Level level, BlockPos pos) {
        return level.getBlockState(pos.above()).is(BlockTagGenerator.TROPHIES);
    }

    private void warnIneligiblePlayers(Level level, BlockPos pos) {
        for (Player player : level.getEntitiesOfClass(Player.class, new AABB(pos).inflate(16.0))) {
            if (this.isPlayerEligible(player)) continue;
            player.displayClientMessage((Component)Component.translatable((String)"misc.twilightforest.pedestal_ineligible"), true);
        }
    }

    private boolean areNearbyPlayersEligible(Level level, BlockPos pos) {
        for (Player player : level.getEntitiesOfClass(Player.class, new AABB(pos).inflate(16.0))) {
            if (!this.isPlayerEligible(player)) continue;
            return true;
        }
        return false;
    }

    private boolean isPlayerEligible(Player player) {
        return PlayerHelper.doesPlayerHaveRequiredAdvancements(player, TwilightForestMod.prefix("progress_lich")) || player.getAbilities().instabuild;
    }

    private void doPedestalEffect(Level level, BlockPos pos, BlockState state) {
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
        this.removeNearbyShields(level, pos);
        level.playSound(null, pos, (SoundEvent)TFSounds.PEDESTAL_ACTIVATE.get(), SoundSource.BLOCKS, 4.0f, 0.1f);
    }

    private void rewardNearbyPlayers(Level level, BlockPos pos) {
        for (ServerPlayer player : level.getEntitiesOfClass(ServerPlayer.class, new AABB(pos).inflate(16.0))) {
            ((SimpleAdvancementTrigger)((Object)TFAdvancements.PLACED_TROPHY_ON_PEDESTAL.get())).trigger(player);
            player.awardStat((ResourceLocation)TFStats.TROPHY_PEDESTALS_ACTIVATED.get());
        }
    }

    private void removeNearbyShields(Level level, BlockPos pos) {
        for (int sx = -5; sx <= 5; ++sx) {
            for (int sy = -5; sy <= 5; ++sy) {
                for (int sz = -5; sz <= 5; ++sz) {
                    if (level.getBlockState(pos.offset(sx, sy, sz)).getBlock() != TFBlocks.STRONGHOLD_SHIELD.get()) continue;
                    level.destroyBlock(pos.offset(sx, sy, sz), false);
                }
            }
        }
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter getter, BlockPos pos) {
        return (Boolean)state.getValue((Property)ACTIVE) != false ? super.getDestroyProgress(state, player, getter, pos) : -1.0f;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        Block trophy = level.getBlockState(pos.above()).getBlock();
        if (trophy instanceof TrophyBlock) {
            TrophyBlock value = (TrophyBlock)trophy;
            return value.getComparatorValue();
        }
        return 0;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return (Boolean)state.getValue((Property)ACTIVE) != false ? PushReaction.NORMAL : PushReaction.BLOCK;
    }
}

