/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SpecialStemLeavesBlock
extends LeavesBlock {
    protected final Predicate<BlockState> stemPredicate;

    public SpecialStemLeavesBlock(BlockBehaviour.Properties properties, Predicate<BlockState> stemPredicate) {
        super(properties);
        this.stemPredicate = stemPredicate;
    }

    public void tick(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource randomSource) {
        serverLevel.setBlock(pos, this.updateDistance(state, (LevelAccessor)serverLevel, pos), 3);
    }

    protected BlockState updateDistance(BlockState state, LevelAccessor levelAccessor, BlockPos pos) {
        int i = 7;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            mutableBlockPos.setWithOffset((Vec3i)pos, direction);
            i = Math.min(i, this.getDistanceAt(levelAccessor.getBlockState((BlockPos)mutableBlockPos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    protected int getDistanceAt(BlockState state) {
        return this.stemPredicate.test(state) ? 0 : (state.getBlock() instanceof LeavesBlock ? (Integer)state.getValue((Property)DISTANCE) : 7);
    }
}

