/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import twilightforest.block.CritterBlock;
import twilightforest.block.entity.CicadaBlockEntity;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFSounds;
import twilightforest.loot.TFLootTables;

public class CicadaBlock
extends CritterBlock {
    public static final MapCodec<CicadaBlock> CODEC = CicadaBlock.simpleCodec(CicadaBlock::new);

    public CicadaBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CicadaBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return CicadaBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TFBlockEntities.CICADA.get()), CicadaBlockEntity::tick);
    }

    @Override
    public ResourceKey<LootTable> getSquishLootTable() {
        return TFLootTables.CICADA_SQUISH_DROPS;
    }

    public void destroy(LevelAccessor accessor, BlockPos pos, BlockState state) {
        super.destroy(accessor, pos, state);
        if (accessor.isClientSide()) {
            Minecraft.getInstance().getSoundManager().stop(((SoundEvent)TFSounds.CICADA.get()).getLocation(), SoundSource.NEUTRAL);
        }
    }
}

