/*
 * Decompiled with CFR 0.152.
 */
package fuzs.moblassos.world.item;

import fuzs.moblassos.MobLassos;
import fuzs.moblassos.config.ServerConfig;
import fuzs.moblassos.init.ModRegistry;
import fuzs.moblassos.util.LassoMobHelper;
import fuzs.moblassos.world.item.LassoType;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.init.v3.registry.LookupHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LassoItem
extends Item {
    public static final String KEY_REMAINING_TIME_IN_SECONDS = "item.moblassos.lasso.remaining";
    private static final int BAR_COLOR = Mth.color((float)0.4f, (float)0.4f, (float)1.0f);
    private final LassoType type;

    public LassoItem(Item.Properties properties, LassoType type) {
        super(properties.stacksTo(1).component(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)false).component(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY));
        this.type = type;
    }

    public static EventResultHolder<InteractionResult> onEntityInteract(Player player, Level level, InteractionHand hand, Entity entity) {
        ItemStack itemInHand = player.getItemInHand(hand);
        Item item = itemInHand.getItem();
        if (item instanceof LassoItem) {
            LassoItem item2 = (LassoItem)item;
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (entity.isAlive()) {
                    if (!itemInHand.has((DataComponentType)ModRegistry.ENTITY_RELEASE_TIME_DATA_COMPONENT_TYPE.value()) && !item2.hasStoredEntity(itemInHand) && item2.type.canPlayerPickUp(player, mob) && !player.level().isClientSide) {
                        entity.stopRiding();
                        entity.ejectPassengers();
                        entity.playSound((SoundEvent)ModRegistry.LASSO_PICK_UP_SOUND_EVENT.value());
                        if (entity.hasCustomName()) {
                            itemInHand.set(DataComponents.CUSTOM_NAME, (Object)entity.getCustomName());
                        }
                        CompoundTag compoundTag = LassoMobHelper.saveEntity(entity);
                        entity.discard();
                        itemInHand.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)compoundTag));
                        if (item2.type.hasMaxHoldingTime()) {
                            itemInHand.set((DataComponentType)ModRegistry.ENTITY_PICK_UP_TIME_DATA_COMPONENT_TYPE.value(), (Object)level.getGameTime());
                        }
                    }
                    return EventResultHolder.interrupt((Object)InteractionResult.sidedSuccess((boolean)player.level().isClientSide));
                }
            }
        }
        return EventResultHolder.pass();
    }

    public int getColor(ItemStack itemStack, int tintIndex) {
        if (tintIndex == 0) {
            return -1;
        }
        SpawnEggItem spawnEggItem = SpawnEggItem.byId(this.getStoredEntityType(itemStack));
        if (spawnEggItem == null) {
            return -1;
        }
        return spawnEggItem.getColor(tintIndex - 1);
    }

    public boolean hasStoredEntity(ItemStack itemStack) {
        return !((CustomData)itemStack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).isEmpty();
    }

    @Nullable
    public EntityType<?> getStoredEntityType(ItemStack itemStack) {
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        return EntityType.by((CompoundTag)customData.getUnsafe()).orElse(null);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (this.hasStoredEntity(context.getItemInHand())) {
            Level level = context.getLevel();
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            ItemStack itemInHand = context.getItemInHand();
            BlockPos blockPos = context.getClickedPos();
            Direction direction = context.getClickedFace();
            BlockState blockState = level.getBlockState(blockPos);
            BlockPos releasePos = blockState.getCollisionShape((BlockGetter)level, blockPos).isEmpty() ? blockPos : blockPos.relative(direction);
            this.releaseContents((Entity)context.getPlayer(), level, itemInHand, blockPos, releasePos);
            this.tryConvertPickUpTime(level, itemInHand);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void releaseContents(@Nullable Entity entity, Level level, ItemStack itemStack, BlockPos clickedPos, BlockPos releasePos) {
        CompoundTag tag = ((CustomData)itemStack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (this.releaseContentAt(tag, level, releasePos, itemStack)) {
            level.gameEvent(entity, (Holder)GameEvent.ENTITY_PLACE, clickedPos);
        }
        itemStack.set(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        itemStack.remove(DataComponents.CUSTOM_NAME);
    }

    public void tryConvertPickUpTime(Level level, ItemStack itemStack) {
        if (itemStack.has((DataComponentType)ModRegistry.ENTITY_PICK_UP_TIME_DATA_COMPONENT_TYPE.value())) {
            long pickUpTime = (Long)itemStack.get((DataComponentType)ModRegistry.ENTITY_PICK_UP_TIME_DATA_COMPONENT_TYPE.value());
            itemStack.remove((DataComponentType)ModRegistry.ENTITY_PICK_UP_TIME_DATA_COMPONENT_TYPE.value());
            long currentHoldingTime = level.getGameTime() - pickUpTime;
            long releaseTime = level.getGameTime() + Math.min(0L, currentHoldingTime - (long)this.getMaxHoldingTime(level, itemStack)) / 5L;
            itemStack.set((DataComponentType)ModRegistry.ENTITY_RELEASE_TIME_DATA_COMPONENT_TYPE.value(), (Object)releaseTime);
        }
    }

    private boolean releaseContentAt(CompoundTag tag, Level level, BlockPos pos, ItemStack itemStack) {
        if (!level.isClientSide && !tag.isEmpty()) {
            LassoMobHelper.removeTagKeys((ServerLevel)level, tag);
            return EntityType.create((CompoundTag)tag, (Level)level).map(entity -> {
                LassoMobHelper.moveEntityTo(entity, level, pos, true);
                entity.setDeltaMovement(Vec3.ZERO);
                level.addFreshEntity(entity);
                if (itemStack.has(DataComponents.CUSTOM_NAME) && entity instanceof LivingEntity) {
                    entity.setCustomName(itemStack.getHoverName());
                }
                entity.playSound((SoundEvent)ModRegistry.LASSO_RELEASE_SOUND_EVENT.value());
                return entity;
            }).isPresent();
        }
        return false;
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int slotId, boolean isSelected) {
        int hostileDamageRate;
        if (this.type == LassoType.HOSTILE && this.hasStoredEntity(itemStack) && (hostileDamageRate = ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).hostileDamageRate) != -1 && level.getGameTime() % ((long)hostileDamageRate * 20L) == 0L) {
            entity.hurt(level.damageSources().magic(), 1.0f);
        }
        if (this.type.hasMaxHoldingTime()) {
            long currentHoldingTime;
            int maxHoldingTime;
            if (itemStack.has((DataComponentType)ModRegistry.ENTITY_PICK_UP_TIME_DATA_COMPONENT_TYPE.value())) {
                maxHoldingTime = this.getMaxHoldingTime(level, itemStack);
                currentHoldingTime = this.getCurrentHoldingTime(level, itemStack, (DataComponentType<Long>)((DataComponentType)ModRegistry.ENTITY_PICK_UP_TIME_DATA_COMPONENT_TYPE.value()), maxHoldingTime);
                if (currentHoldingTime >= (long)maxHoldingTime) {
                    this.releaseContents(entity, level, itemStack, entity.blockPosition(), entity.blockPosition());
                    this.tryConvertPickUpTime(level, itemStack);
                }
            }
            if (itemStack.has((DataComponentType)ModRegistry.ENTITY_RELEASE_TIME_DATA_COMPONENT_TYPE.value())) {
                maxHoldingTime = this.getMaxHoldingTime(level, itemStack) / 5;
                currentHoldingTime = this.getCurrentHoldingTime(level, itemStack, (DataComponentType<Long>)((DataComponentType)ModRegistry.ENTITY_RELEASE_TIME_DATA_COMPONENT_TYPE.value()), maxHoldingTime);
                if (currentHoldingTime >= (long)maxHoldingTime) {
                    itemStack.remove((DataComponentType)ModRegistry.ENTITY_RELEASE_TIME_DATA_COMPONENT_TYPE.value());
                }
            }
        }
    }

    public boolean isBarVisible(ItemStack itemStack) {
        return this.type.hasMaxHoldingTime() && (itemStack.has((DataComponentType)ModRegistry.ENTITY_PICK_UP_TIME_DATA_COMPONENT_TYPE.value()) || itemStack.has((DataComponentType)ModRegistry.ENTITY_RELEASE_TIME_DATA_COMPONENT_TYPE.value()));
    }

    public int getBarWidth(ItemStack itemStack) {
        int maxHoldingTime = this.getMaxHoldingTime(Proxy.INSTANCE.getClientLevel(), itemStack);
        long currentHoldingTime = 0L;
        if (itemStack.has((DataComponentType)ModRegistry.ENTITY_PICK_UP_TIME_DATA_COMPONENT_TYPE.value())) {
            currentHoldingTime = this.getCurrentHoldingTime(Proxy.INSTANCE.getClientLevel(), itemStack, (DataComponentType<Long>)((DataComponentType)ModRegistry.ENTITY_PICK_UP_TIME_DATA_COMPONENT_TYPE.value()), maxHoldingTime);
        }
        if (itemStack.has((DataComponentType)ModRegistry.ENTITY_RELEASE_TIME_DATA_COMPONENT_TYPE.value())) {
            currentHoldingTime = (long)(maxHoldingTime /= 5) - this.getCurrentHoldingTime(Proxy.INSTANCE.getClientLevel(), itemStack, (DataComponentType<Long>)((DataComponentType)ModRegistry.ENTITY_RELEASE_TIME_DATA_COMPONENT_TYPE.value()), maxHoldingTime);
        }
        return Math.round(13.0f - (float)currentHoldingTime * 13.0f / (float)maxHoldingTime);
    }

    public int getBarColor(ItemStack itemStack) {
        return BAR_COLOR;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (context != Item.TooltipContext.EMPTY) {
            if (this.hasStoredEntity(itemStack)) {
                MutableComponent component = Component.translatable((String)"gui.entity_tooltip.type", (Object[])new Object[]{this.getStoredEntityType(itemStack).getDescription()});
                tooltipComponents.add((Component)component.withStyle(ChatFormatting.BLUE));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(ChatFormatting.GOLD));
            }
            if (tooltipFlag.isAdvanced() && MobLassos.CONFIG.getHolder(ServerConfig.class).isAvailable()) {
                boolean hasPickUpTime = itemStack.has((DataComponentType)ModRegistry.ENTITY_PICK_UP_TIME_DATA_COMPONENT_TYPE.value());
                boolean hasReleaseTime = itemStack.has((DataComponentType)ModRegistry.ENTITY_RELEASE_TIME_DATA_COMPONENT_TYPE.value());
                if (hasPickUpTime || hasReleaseTime) {
                    int maxHoldingTime = this.getMaxHoldingTime(context.registries(), itemStack);
                    long currentHoldingTime = 0L;
                    if (hasPickUpTime) {
                        currentHoldingTime = this.getCurrentHoldingTime(Proxy.INSTANCE.getClientLevel(), itemStack, (DataComponentType<Long>)((DataComponentType)ModRegistry.ENTITY_PICK_UP_TIME_DATA_COMPONENT_TYPE.value()), maxHoldingTime);
                    }
                    if (hasReleaseTime) {
                        currentHoldingTime = this.getCurrentHoldingTime(Proxy.INSTANCE.getClientLevel(), itemStack, (DataComponentType<Long>)((DataComponentType)ModRegistry.ENTITY_RELEASE_TIME_DATA_COMPONENT_TYPE.value()), maxHoldingTime /= 5);
                    }
                    tooltipComponents.add((Component)Component.translatable((String)KEY_REMAINING_TIME_IN_SECONDS, (Object[])new Object[]{((long)maxHoldingTime - currentHoldingTime) / 20L}).withStyle(ChatFormatting.GRAY));
                }
            }
        }
    }

    private long getCurrentHoldingTime(Level level, ItemStack itemStack, DataComponentType<Long> dataComponentType, int maxHoldingTime) {
        long time = (Long)itemStack.getOrDefault(dataComponentType, (Object)-1L);
        long currentHoldingTime = level.getGameTime() - time;
        return Math.min(currentHoldingTime, (long)maxHoldingTime);
    }

    public int getMaxHoldingTime(Level level, ItemStack itemStack) {
        return this.getMaxHoldingTime((HolderLookup.Provider)level.registryAccess(), itemStack);
    }

    public int getMaxHoldingTime(HolderLookup.Provider registries, ItemStack itemStack) {
        int time = this.type.getMaxHoldingTime();
        Holder enchantment = LookupHelper.lookupEnchantment((HolderLookup.Provider)registries, ModRegistry.HOLDING_ENCHANTMENT);
        int enchantmentLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantment, (ItemStack)itemStack);
        if (enchantmentLevel > 0) {
            time += (int)((double)(time * enchantmentLevel) * ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).holdingMultiplier);
        }
        return time;
    }

    public void onDestroyed(ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.getItem();
        if (this.hasStoredEntity(itemStack)) {
            CompoundTag storedEntity = ((CustomData)itemStack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
            this.releaseContentAt(storedEntity, itemEntity.level(), itemEntity.blockPosition(), itemStack);
        }
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }
}

