/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import org.cyclops.cyclopscore.config.extendedconfig.EntityConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.client.render.entity.ModelWerewolf;
import org.cyclops.evilcraft.client.render.entity.RenderWerewolf;
import org.cyclops.evilcraft.entity.monster.EntityWerewolf;

public class EntityWerewolfConfig
extends EntityConfig<EntityWerewolf> {
    @OnlyIn(value=Dist.CLIENT)
    public static ModelLayerLocation MODEL;

    public EntityWerewolfConfig() {
        super((ModBase)EvilCraft._instance, "werewolf", eConfig -> EntityType.Builder.of(EntityWerewolf::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 2.9f), EntityWerewolfConfig.getDefaultSpawnEggItemConfigConstructor((ModBase)EvilCraft._instance, (String)"werewolf_spawn_egg", (int)Helpers.RGBToInt((int)105, (int)67, (int)18), (int)Helpers.RGBToInt((int)57, (int)25, (int)10)));
        EvilCraft._instance.getModEventBus().addListener(this::onEntityAttributeCreationEvent);
        if (MinecraftHelpers.isClientSide()) {
            ModelLoader.registerModel();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onForgeRegistered() {
        super.onForgeRegistered();
        ClientHooks.registerLayerDefinition((ModelLayerLocation)MODEL, ModelWerewolf::createBodyLayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityRenderer<? super EntityWerewolf> getRender(EntityRendererProvider.Context renderContext, ItemRenderer itemRenderer) {
        return new RenderWerewolf(renderContext, this, new ModelWerewolf(renderContext.bakeLayer(MODEL)), 0.5f);
    }

    public void onEntityAttributeCreationEvent(EntityAttributeCreationEvent event) {
        event.put((EntityType)this.getInstance(), Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.ATTACK_DAMAGE, 7.0).add(Attributes.STEP_HEIGHT, 1.0).build());
    }

    public static class ModelLoader {
        public static Object registerModel() {
            MODEL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"werewolf"), "main");
            return null;
        }
    }
}

