/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.blockentity.BlockEntityDarkTank;
import org.cyclops.evilcraft.client.render.model.ModelDarkTankBaked;
import org.joml.Matrix4f;

public class RenderBlockEntityDarkTank
implements BlockEntityRenderer<BlockEntityDarkTank> {
    private static final float OFFSET = 0.01f;
    private static final float MINY = 0.01f;
    private static final float MIN = 0.135f;
    private static final float MAX = 0.865f;
    private static float[][][] coordinates = new float[][][]{new float[][]{{0.135f, 0.01f, 0.135f}, {0.135f, 0.01f, 0.865f}, {0.865f, 0.01f, 0.865f}, {0.865f, 0.01f, 0.135f}}, new float[][]{{0.135f, 0.865f, 0.135f}, {0.135f, 0.865f, 0.865f}, {0.865f, 0.865f, 0.865f}, {0.865f, 0.865f, 0.135f}}, new float[][]{{0.135f, 0.01f, 0.135f}, {0.135f, 0.865f, 0.135f}, {0.865f, 0.865f, 0.135f}, {0.865f, 0.01f, 0.135f}}, new float[][]{{0.135f, 0.865f, 0.865f}, {0.135f, 0.01f, 0.865f}, {0.865f, 0.01f, 0.865f}, {0.865f, 0.865f, 0.865f}}, new float[][]{{0.135f, 0.865f, 0.135f}, {0.135f, 0.01f, 0.135f}, {0.135f, 0.01f, 0.865f}, {0.135f, 0.865f, 0.865f}}, new float[][]{{0.865f, 0.01f, 0.135f}, {0.865f, 0.865f, 0.135f}, {0.865f, 0.865f, 0.865f}, {0.865f, 0.01f, 0.865f}}};

    public RenderBlockEntityDarkTank(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityDarkTank tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        FluidStack fluid = tile.getTank().getFluid();
        RenderHelpers.renderFluidContext((FluidStack)fluid, (PoseStack)matrixStackIn, () -> {
            float height = (float)(tile.getFillRatio() * (double)0.99f);
            int brightness = Math.max(combinedLightIn, fluid.getFluid().getFluidType().getLightLevel(fluid));
            RenderBlockEntityDarkTank.renderFluidSides(height, tile.getTank().getFluid(), tile.isEnabled(), brightness, matrixStackIn, bufferIn);
        });
    }

    public static void renderFluidSides(float height, FluidStack fluid, boolean flowing, int brightness, PoseStack matrixStackIn, MultiBufferSource bufferIn) {
        int l2 = brightness >> 16 & 0xFFFF;
        int i3 = brightness & 0xFFFF;
        Triple colorParts = RenderHelpers.getFluidVertexBufferColor((FluidStack)fluid);
        float r = ((Float)colorParts.getLeft()).floatValue();
        float g = ((Float)colorParts.getMiddle()).floatValue();
        float b = ((Float)colorParts.getRight()).floatValue();
        float a = 1.0f;
        Matrix4f matrix = matrixStackIn.last().pose();
        for (Direction side : DirectionHelpers.DIRECTIONS) {
            TextureAtlasSprite icon = ModelDarkTankBaked.getFluidIcon(fluid, flowing, side);
            VertexConsumer vb = bufferIn.getBuffer(RenderType.text((ResourceLocation)icon.atlasLocation()));
            float[][] c = coordinates[side.ordinal()];
            float minV = icon.getV0();
            float maxV = (icon.getV1() - icon.getV0()) * height + icon.getV0();
            float minU = icon.getU0();
            float maxU = icon.getU1();
            if (side == Direction.WEST || side == Direction.SOUTH) {
                float tmp = minV;
                minV = maxV;
                maxV = tmp;
            } else if (side == Direction.UP || side == Direction.DOWN) {
                maxV = icon.getV1();
            }
            vb.addVertex(matrix, c[0][0], RenderBlockEntityDarkTank.getHeight(side, c[0][1], height), c[0][2]).setColor(r, g, b, a).setUv(minU, maxV).setUv2(l2, i3);
            vb.addVertex(matrix, c[1][0], RenderBlockEntityDarkTank.getHeight(side, c[1][1], height), c[1][2]).setColor(r, g, b, a).setUv(minU, minV).setUv2(l2, i3);
            vb.addVertex(matrix, c[2][0], RenderBlockEntityDarkTank.getHeight(side, c[2][1], height), c[2][2]).setColor(r, g, b, a).setUv(maxU, minV).setUv2(l2, i3);
            vb.addVertex(matrix, c[3][0], RenderBlockEntityDarkTank.getHeight(side, c[3][1], height), c[3][2]).setColor(r, g, b, a).setUv(maxU, maxV).setUv2(l2, i3);
        }
    }

    private static float getHeight(Direction side, float height, float replaceHeight) {
        if (height == 0.865f) {
            return replaceHeight;
        }
        return height;
    }
}

