/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.evilcraft.ExtendedDamageSources;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockSanguinaryPedestal;
import org.cyclops.evilcraft.block.BlockSpikedPlateConfig;
import org.cyclops.evilcraft.blockentity.BlockEntitySanguinaryPedestal;
import org.cyclops.evilcraft.core.config.configurable.BlockPressurePlate;

public class BlockSpikedPlate
extends BlockPressurePlate {
    public static final MapCodec<BlockSpikedPlate> CODEC = BlockSpikedPlate.simpleCodec(BlockSpikedPlate::new);

    public BlockSpikedPlate(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BasePressurePlateBlock> codec() {
        return CODEC;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos blockPos) {
        return super.canSurvive(state, world, blockPos) || world.getBlockState(blockPos.offset(0, -1, 0)).getBlock() instanceof BlockSanguinaryPedestal;
    }

    protected boolean damageEntity(ServerLevel world, Entity entity, BlockPos blockPos) {
        if (!(entity instanceof Player) && entity instanceof LivingEntity) {
            float damage = (float)BlockSpikedPlateConfig.damage;
            ((LivingEntity)entity).lastHurtByPlayerTime = 100;
            if (entity.hurt(ExtendedDamageSources.spikedDamage(world), damage)) {
                BlockEntity tile = world.getBlockEntity(blockPos.offset(0, -1, 0));
                if (tile != null && tile instanceof BlockEntitySanguinaryPedestal) {
                    int amount = Mth.floor((float)(damage * (float)BlockSpikedPlateConfig.mobMultiplier));
                    ((BlockEntitySanguinaryPedestal)tile).getBonusFluidHandler().fill(new FluidStack(RegistryEntries.FLUID_BLOOD, amount), IFluidHandler.FluidAction.EXECUTE);
                }
                return true;
            }
        }
        return false;
    }

    protected int getSignalStrength(Level world, BlockPos blockPos) {
        VoxelShape shape = this.getShape(world.getBlockState(blockPos), (BlockGetter)world, blockPos, CollisionContext.empty());
        List list = world.getEntitiesOfClass(LivingEntity.class, shape.bounds().expandTowards(0.0, 1.0, 1.0).move(blockPos));
        int ret = 0;
        if (!world.isClientSide() && !list.isEmpty()) {
            for (LivingEntity entity : list) {
                if (entity.isIgnoringBlockTriggers() || !this.damageEntity((ServerLevel)world, (Entity)entity, blockPos)) continue;
                ret = 15;
            }
        }
        return ret;
    }

    protected int getSignalForState(BlockState blockState) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)POWERED, (Comparable)Boolean.valueOf(false)) != false ? 15 : 0;
    }

    protected BlockState setSignalForState(BlockState blockState, int meta) {
        return (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(meta > 0));
    }
}

