/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.evilcraft.entity.block.EntityLightningBombPrimed;
import org.cyclops.evilcraft.entity.item.EntityLightningGrenade;

public class BlockLightningBomb
extends Block {
    public static final BooleanProperty PRIMED = BooleanProperty.create((String)"primed");

    public BlockLightningBomb(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PRIMED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PRIMED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)PRIMED, (Comparable)Boolean.valueOf(false));
    }

    public void onPlace(BlockState blockState, Level world, BlockPos blockPos, BlockState oldState, boolean isMoving) {
        super.onPlace(blockState, world, blockPos, oldState, isMoving);
        if (world.hasNeighborSignal(blockPos)) {
            this.destroy((LevelAccessor)world, blockPos, (BlockState)blockState.setValue((Property)PRIMED, (Comparable)Boolean.valueOf(true)));
            world.removeBlock(blockPos, false);
        }
    }

    public void neighborChanged(BlockState blockState, Level world, BlockPos blockPos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(blockState, world, blockPos, blockIn, fromPos, isMoving);
        if (world.hasNeighborSignal(blockPos)) {
            this.destroy((LevelAccessor)world, blockPos, (BlockState)blockState.setValue((Property)PRIMED, (Comparable)Boolean.valueOf(true)));
            world.removeBlock(blockPos, false);
        }
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos blockPos, Explosion explosion) {
        if (!world.isClientSide()) {
            EntityLightningBombPrimed entityprimed = new EntityLightningBombPrimed(world, (float)blockPos.getX() + 0.5f, (float)blockPos.getY() + 0.5f, (float)blockPos.getZ() + 0.5f, explosion.getIndirectSourceEntity());
            entityprimed.setFuse(world.random.nextInt(entityprimed.getFuse() / 4) + entityprimed.getFuse() / 8);
            world.addFreshEntity((Entity)entityprimed);
            world.removeBlock(blockPos, false);
        }
    }

    public void destroy(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        super.destroy(world, blockPos, blockState);
        this.primeBomb(world, blockPos, blockState, null);
    }

    public void primeBomb(LevelAccessor world, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity placer) {
        if (!world.isClientSide() && ((Boolean)blockState.getValue((Property)PRIMED)).booleanValue()) {
            EntityLightningBombPrimed entityprimed = new EntityLightningBombPrimed((Level)world, (float)blockPos.getX() + 0.5f, (float)blockPos.getY() + 0.5f, (float)blockPos.getZ() + 0.5f, placer);
            world.addFreshEntity((Entity)entityprimed);
            world.playSound(null, blockPos, SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos blockPos, Player player, BlockHitResult p_225533_6_) {
        InteractionHand hand = player.getUsedItemHand();
        if (!(player.getItemInHand(hand).isEmpty() || player.getItemInHand(hand).getItem() != Items.FLINT_AND_STEEL && player.getItemInHand(hand).getItem() != Items.FIRE_CHARGE)) {
            this.primeBomb((LevelAccessor)world, blockPos, (BlockState)this.defaultBlockState().setValue((Property)PRIMED, (Comparable)Boolean.valueOf(true)), (LivingEntity)player);
            world.removeBlock(blockPos, false);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                player.getItemInHand(hand).hurtAndBreak(1, serverLevel, (LivingEntity)player, e -> {});
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, world, blockPos, player, p_225533_6_);
    }

    public void stepOn(Level world, BlockPos blockPos, BlockState blockState, Entity entity) {
        BlockState primedState = (BlockState)this.defaultBlockState().setValue((Property)PRIMED, (Comparable)Boolean.valueOf(true));
        if (entity instanceof AbstractArrow && !world.isClientSide()) {
            AbstractArrow entityarrow = (AbstractArrow)entity;
            if (entityarrow.isOnFire()) {
                this.primeBomb((LevelAccessor)world, blockPos, primedState, entityarrow.getOwner() instanceof LivingEntity ? (LivingEntity)entityarrow.getOwner() : null);
                world.removeBlock(blockPos, false);
            }
        } else if (entity instanceof EntityLightningGrenade && !world.isClientSide()) {
            EntityLightningGrenade entitygrenade = (EntityLightningGrenade)entity;
            this.primeBomb((LevelAccessor)world, blockPos, primedState, entitygrenade.getOwner() instanceof LivingEntity ? (LivingEntity)entitygrenade.getOwner() : null);
            world.removeBlock(blockPos, false);
        }
    }

    public boolean dropFromExplosion(Explosion explosion) {
        return false;
    }
}

