/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityDisplayStand;

public class BlockDisplayStand
extends BlockWithEntity {
    public static final MapCodec<BlockDisplayStand> CODEC = BlockDisplayStand.simpleCodec(BlockDisplayStand::new);
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Direction[])Direction.values());
    public static final BooleanProperty AXIS_X = BooleanProperty.create((String)"axis_x");
    public static final ModelProperty<Direction.AxisDirection> DIRECTION = new ModelProperty();
    public static final ModelProperty<ItemStack> TYPE = new ModelProperty();
    public static final Map<Direction, VoxelShape> FACING_BOUNDS = ImmutableMap.builder().put((Object)Direction.DOWN, (Object)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0)).put((Object)Direction.UP, (Object)Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0)).put((Object)Direction.WEST, (Object)Block.box((double)0.0, (double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)10.0)).put((Object)Direction.EAST, (Object)Block.box((double)8.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0)).put((Object)Direction.NORTH, (Object)Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)8.0)).put((Object)Direction.SOUTH, (Object)Block.box((double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)10.0, (double)16.0)).build();

    public BlockDisplayStand(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityDisplayStand::new);
        NeoForge.EVENT_BUS.register((Object)this);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : BlockDisplayStand.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_DISPLAY_STAND.get()), (BlockEntityTicker)new BlockEntityTickerDelayed());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, AXIS_X});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return FACING_BOUNDS.get(BlockHelpers.getSafeBlockStateProperty((BlockState)state, (Property)FACING, (Comparable)Direction.DOWN));
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos blockPos) {
        return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityDisplayStand.class).map(tile -> !tile.getInventory().getItem(0).isEmpty() ? 15 : 0).orElse(0);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = super.getStateForPlacement(context);
        blockState = (BlockState)blockState.setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite());
        Direction playerFacing = context.getPlayer().getDirection();
        boolean axisX = context.getClickedFace().getOpposite() == Direction.DOWN || context.getClickedFace().getOpposite() == Direction.UP ? playerFacing.getAxis() == Direction.Axis.X : playerFacing.getAxis() != Direction.Axis.X && playerFacing.getAxis() != Direction.Axis.Z;
        blockState = (BlockState)blockState.setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(axisX));
        return blockState;
    }

    public void setPlacedBy(Level world, BlockPos blockPos, BlockState blockState, LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(world, blockPos, blockState, entity, stack);
        if (!world.isClientSide()) {
            BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityDisplayStand.class).ifPresent(tile -> {
                tile.setDisplayStandType(this.getDisplayStandType(stack));
                tile.setDirection(entity.getDirection().getAxisDirection());
            });
        }
    }

    public BlockState rotate(BlockState blockState, LevelAccessor world, BlockPos pos, Rotation direction) {
        return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityDisplayStand.class).map(tile -> {
            if (tile.getDirection() == Direction.AxisDirection.POSITIVE) {
                if (((Boolean)blockState.getValue((Property)AXIS_X)).booleanValue()) {
                    tile.setDirection(Direction.AxisDirection.POSITIVE);
                    return (BlockState)blockState.setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(false));
                }
                tile.setDirection(Direction.AxisDirection.NEGATIVE);
                return (BlockState)blockState.setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(true));
            }
            if (((Boolean)blockState.getValue((Property)AXIS_X)).booleanValue()) {
                tile.setDirection(Direction.AxisDirection.NEGATIVE);
                return (BlockState)blockState.setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(false));
            }
            tile.setDirection(Direction.AxisDirection.POSITIVE);
            return (BlockState)blockState.setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(true));
        }).orElse(blockState);
    }

    public void fillItemCategory(NonNullList<ItemStack> list) {
        try {
            BuiltInRegistries.ITEM.getTag(ItemTags.PLANKS).ifPresent(values -> values.forEach(holder -> {
                Item item = (Item)holder.value();
                if (item instanceof BlockItem) {
                    BlockState plankWoodBlockState = BlockHelpers.getBlockStateFromItemStack((ItemStack)new ItemStack((ItemLike)item));
                    list.add((Object)this.getTypedDisplayStandItem(plankWoodBlockState));
                }
            }));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public ItemStack getTypedDisplayStandItem(BlockState blockState) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        itemStack.set(RegistryEntries.COMPONENT_DISPLAY_STAND_TYPE, (Object)blockState);
        return itemStack;
    }

    public ItemStack getDisplayStandType(ItemStack displayStandStack) {
        BlockState blockState = (BlockState)displayStandStack.get(RegistryEntries.COMPONENT_DISPLAY_STAND_TYPE);
        if (blockState != null) {
            return BlockHelpers.getItemStackFromBlockState((BlockState)blockState);
        }
        return null;
    }

    public static void setDisplayStandType(ItemStack displayStandStack, ItemStack type) {
        displayStandStack.set(RegistryEntries.COMPONENT_DISPLAY_STAND_TYPE, (Object)BlockHelpers.getBlockStateFromItemStack((ItemStack)type));
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getItemStack().isEmpty() && event.getItemStack().getCapability(Capabilities.FluidHandler.ITEM) != null && event.getLevel().getBlockState(event.getPos()).getBlock() == this) {
            event.setUseBlock(TriState.TRUE);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult p_225533_6_) {
        ItemStack itemStack = player.getItemInHand(player.getUsedItemHand());
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntityDisplayStand tile = BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityDisplayStand.class).orElse(null);
        if (tile != null) {
            ItemStack tileStack = tile.getInventory().getItem(0);
            if ((itemStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)tileStack) && tileStack.getCount() < tileStack.getMaxStackSize()) && !tileStack.isEmpty()) {
                if (!itemStack.isEmpty()) {
                    tileStack.grow(itemStack.getCount());
                }
                player.getInventory().setItem(player.getInventory().selected, tileStack);
                tile.getInventory().setItem(0, ItemStack.EMPTY);
                tile.sendUpdate();
                return InteractionResult.SUCCESS;
            }
            if (!itemStack.isEmpty() && tile.getInventory().getItem(0).isEmpty()) {
                tile.getInventory().setItem(0, itemStack.split(1));
                if (itemStack.getCount() <= 0) {
                    player.getInventory().setItem(player.getInventory().selected, ItemStack.EMPTY);
                }
                tile.sendUpdate();
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        ItemStack blockType = this.getDisplayStandType(stack);
        if (blockType != null) {
            tooltip.add((Component)((MutableComponent)blockType.getHoverName()).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return BlockHelpers.doesBlockHaveSolidTopSurface((LevelReader)worldIn, (BlockPos)pos);
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!state.canSurvive((LevelReader)worldIn, pos)) {
            worldIn.destroyBlock(pos, true);
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.canSurvive((LevelReader)worldIn, currentPos)) {
            worldIn.scheduleTick(currentPos, (Block)this, 1);
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void onRemove(BlockState oldState, Level world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!world.isClientSide() && oldState.getBlock() != newState.getBlock()) {
            BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityDisplayStand.class).ifPresent(tile -> InventoryHelpers.dropItems((Level)world, (Container)tile.getInventory(), (BlockPos)blockPos));
        }
        super.onRemove(oldState, world, blockPos, newState, isMoving);
    }
}

