/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayerFactory;

public class ExtendedDamageSources {
    public static final ResourceKey<DamageType> DAMAGE_TYPE_BROOM = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"broom"));
    public static final ResourceKey<DamageType> DAMAGE_TYPE_DIE_WITHOUT_ANY_REASON = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"die_without_any_reason"));
    public static final ResourceKey<DamageType> DAMAGE_TYPE_DISTORTED = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"distorted"));
    public static final ResourceKey<DamageType> DAMAGE_TYPE_PALING = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"paling"));
    public static final ResourceKey<DamageType> DAMAGE_TYPE_SPIKED = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"spiked"));
    public static final ResourceKey<DamageType> DAMAGE_TYPE_VENGEANCE_BEAM = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"vengeance_beam"));

    public static DamageSource dieWithoutAnyReason(Level level) {
        return new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DAMAGE_TYPE_DIE_WITHOUT_ANY_REASON));
    }

    public static DamageSource distorted(Level level) {
        return new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DAMAGE_TYPE_DISTORTED));
    }

    public static DamageSource spikedDamage(ServerLevel level) {
        return new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DAMAGE_TYPE_SPIKED), (Entity)FakePlayerFactory.getMinecraft((ServerLevel)level));
    }

    public static DamageSource paling(Level level) {
        return new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DAMAGE_TYPE_PALING));
    }

    public static DamageSource broomDamage(LivingEntity attacker) {
        return new DamageSource((Holder)attacker.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DAMAGE_TYPE_BROOM), (Entity)attacker);
    }

    public static DamageSource vengeanceBeam(LivingEntity attacker) {
        return new DamageSource((Holder)attacker.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DAMAGE_TYPE_VENGEANCE_BEAM), (Entity)attacker);
    }
}

