/*
 * Decompiled with CFR 0.152.
 */
package fuzs.swordblockingmechanics.handler;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.data.DefaultedDouble;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import fuzs.swordblockingmechanics.SwordBlockingMechanics;
import fuzs.swordblockingmechanics.capability.ParryCooldownCapability;
import fuzs.swordblockingmechanics.config.ServerConfig;
import fuzs.swordblockingmechanics.init.ModRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SwordBlockingHandler {
    public static final int DEFAULT_ITEM_USE_DURATION = 72000;

    public static EventResultHolder<InteractionResult> onUseItem(Player player, Level level, InteractionHand hand) {
        if (!((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).allowBlockingAndParrying) {
            return EventResultHolder.pass();
        }
        if (player.getItemInHand(hand).is(ModRegistry.CAN_PERFORM_SWORD_BLOCKING_ITEM_TAG) && (!((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).prioritizeOffHand || hand != InteractionHand.MAIN_HAND || SwordBlockingHandler.canActivateBlocking(player, player.getOffhandItem()))) {
            InteractionHand otherHand;
            InteractionHand interactionHand = otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            if ((!((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).requireBothHands || player.getItemInHand(otherHand).isEmpty()) && (double)player.getAttackStrengthScale(0.0f) >= ((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).requiredAttackStrength) {
                player.startUsingItem(hand);
                return EventResultHolder.interrupt((Object)InteractionResult.CONSUME);
            }
        }
        return EventResultHolder.pass();
    }

    public static EventResult onUseItemStart(LivingEntity entity, ItemStack stack, MutableInt remainingUseDuration) {
        if (!((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).allowBlockingAndParrying) {
            return EventResult.PASS;
        }
        if (entity instanceof Player && stack.is(ModRegistry.CAN_PERFORM_SWORD_BLOCKING_ITEM_TAG)) {
            remainingUseDuration.accept(72000);
        }
        return EventResult.PASS;
    }

    public static EventResult onUseItemStop(LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (!((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).allowBlockingAndParrying) {
            return EventResult.PASS;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (stack.is(ModRegistry.CAN_PERFORM_SWORD_BLOCKING_ITEM_TAG)) {
                ((ParryCooldownCapability)ModRegistry.PARRY_COOLDOWN_CAPABILITY.get((Object)player)).resetCooldownTicks();
            }
        }
        return EventResult.PASS;
    }

    public static void onEndPlayerTick(Player player) {
        ((ParryCooldownCapability)ModRegistry.PARRY_COOLDOWN_CAPABILITY.get((Object)player)).tick();
    }

    public static EventResult onLivingAttack(LivingEntity entity, DamageSource damageSource, float damageAmount) {
        Player player;
        if (entity.level().isClientSide || !(entity instanceof Player) || !SwordBlockingHandler.isActiveItemStackBlocking(player = (Player)entity)) {
            return EventResult.PASS;
        }
        if (damageAmount > 0.0f && SwordBlockingHandler.canBlockDamageSource(player, damageSource)) {
            boolean parryIsActive;
            boolean bl = parryIsActive = SwordBlockingHandler.getParryStrengthScale(player) > 0.0;
            if (parryIsActive || ((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).deflectProjectiles && damageSource.is(DamageTypeTags.IS_PROJECTILE)) {
                Entity entity2;
                if (parryIsActive && ((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).damageSwordOnParry || !parryIsActive && ((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).damageSwordOnBlock) {
                    SwordBlockingHandler.hurtSwordInUse(player, damageAmount);
                }
                if (parryIsActive && !damageSource.is(DamageTypeTags.IS_PROJECTILE) && (entity2 = damageSource.getDirectEntity()) instanceof LivingEntity) {
                    LivingEntity directEntity = (LivingEntity)entity2;
                    directEntity.knockback(((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).parryKnockbackStrength, player.getX() - directEntity.getX(), player.getZ() - directEntity.getZ());
                }
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModRegistry.ITEM_SWORD_BLOCK_SOUND_EVENT.value(), player.getSoundSource(), 1.0f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    public static EventResult onLivingHurt(LivingEntity entity, DamageSource source, MutableFloat amount) {
        Player player;
        if (entity instanceof Player && SwordBlockingHandler.isActiveItemStackBlocking(player = (Player)entity) && SwordBlockingHandler.canBlockDamageSource(player, source) && amount.getAsFloat() > 0.0f) {
            if (((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).damageSwordOnBlock) {
                SwordBlockingHandler.hurtSwordInUse(player, amount.getAsFloat());
            }
            double damageAfterBlock = 1.0 + (double)amount.getAsFloat() * (1.0 - ((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).blockedDamage);
            amount.mapFloat(v -> Float.valueOf(Math.min(v.floatValue(), (float)Math.floor(damageAfterBlock))));
        }
        return EventResult.PASS;
    }

    public static EventResult onLivingKnockBack(LivingEntity entity, DefaultedDouble strength, DefaultedDouble ratioX, DefaultedDouble ratioZ) {
        Player player;
        if (entity instanceof Player && SwordBlockingHandler.isActiveItemStackBlocking(player = (Player)entity)) {
            float knockBackMultiplier = 1.0f - (float)((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).knockbackReduction;
            if (knockBackMultiplier == 0.0f) {
                return EventResult.INTERRUPT;
            }
            strength.mapDouble(v -> v * (double)knockBackMultiplier);
        }
        return EventResult.PASS;
    }

    private static boolean canBlockDamageSource(Player player, DamageSource source) {
        Vec3 position;
        AbstractArrow arrow;
        Entity entity = source.getDirectEntity();
        if (entity instanceof AbstractArrow && (arrow = (AbstractArrow)entity).getPierceLevel() > 0) {
            return false;
        }
        if (!source.is(DamageTypeTags.BYPASSES_ARMOR) && (position = source.getSourcePosition()) != null) {
            Vec3 viewVector = player.getViewVector(1.0f);
            position = position.vectorTo(player.position()).normalize();
            position = new Vec3(position.x, 0.0, position.z);
            return position.dot(viewVector) < -Math.cos(((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).protectionArc * Math.PI * 0.5 / 180.0);
        }
        return false;
    }

    public static boolean isActiveItemStackBlocking(Player player) {
        if (!((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).allowBlockingAndParrying) {
            return false;
        }
        return player.isUsingItem() && player.getUseItem().is(ModRegistry.CAN_PERFORM_SWORD_BLOCKING_ITEM_TAG);
    }

    public static double getParryStrengthScale(Player player) {
        ParryCooldownCapability capability = (ParryCooldownCapability)ModRegistry.PARRY_COOLDOWN_CAPABILITY.get((Object)player);
        if (capability.isCooldownActive()) {
            return -capability.getCooldownProgress();
        }
        if (SwordBlockingHandler.isActiveItemStackBlocking(player)) {
            double currentUseDuration = 72000 - player.getUseItemRemainingTicks();
            double parryStrengthScale = 1.0 - currentUseDuration / (double)((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).parryWindow;
            return Mth.clamp((double)parryStrengthScale, (double)0.0, (double)1.0);
        }
        return 0.0;
    }

    private static void hurtSwordInUse(Player player, float damageAmount) {
        if (damageAmount >= 3.0f) {
            int lostDurability = 1 + Mth.floor((float)damageAmount);
            InteractionHand interactionHand = player.getUsedItemHand();
            ItemHelper.hurtAndBreak((ItemStack)player.getUseItem(), (int)lostDurability, (LivingEntity)player, (InteractionHand)interactionHand);
            if (player.getUseItem().isEmpty()) {
                if (interactionHand == InteractionHand.MAIN_HAND) {
                    player.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                } else {
                    player.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
                }
                player.stopUsingItem();
                player.playSound(SoundEvents.ITEM_BREAK, 0.8f, 0.8f + player.level().random.nextFloat() * 0.4f);
            }
        }
    }

    public static boolean canActivateBlocking(Player player, ItemStack itemStack) {
        if (itemStack.is(ModRegistry.OVERRIDES_SWORD_IN_OFFHAND_BLOCKING_ITEM_TAG)) {
            return false;
        }
        return switch (itemStack.getUseAnimation()) {
            case UseAnim.BLOCK, UseAnim.SPYGLASS, UseAnim.BRUSH -> false;
            case UseAnim.EAT, UseAnim.DRINK -> {
                if (!itemStack.has(DataComponents.FOOD) || !player.canEat(((FoodProperties)itemStack.get(DataComponents.FOOD)).canAlwaysEat())) {
                    yield true;
                }
                yield false;
            }
            case UseAnim.BOW, UseAnim.CROSSBOW -> player.getProjectile(itemStack).isEmpty();
            case UseAnim.SPEAR -> {
                if (itemStack.getDamageValue() >= itemStack.getMaxDamage() - 1 || EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)itemStack, (LivingEntity)player) > 0.0f && !player.isInWaterOrRain()) {
                    yield true;
                }
                yield false;
            }
            case UseAnim.TOOT_HORN -> player.getCooldowns().isOnCooldown(itemStack.getItem());
            default -> true;
        };
    }
}

