/*
 * Decompiled with CFR 0.152.
 */
package fuzs.swordblockingmechanics.client.handler;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.puzzleslib.api.client.event.v1.gui.RenderGuiLayerEvents;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.swordblockingmechanics.SwordBlockingMechanics;
import fuzs.swordblockingmechanics.config.ClientConfig;
import fuzs.swordblockingmechanics.handler.SwordBlockingHandler;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class AttackIndicatorInGuiHandler {
    public static final ResourceLocation GUI_ICONS_LOCATION = SwordBlockingMechanics.id("textures/gui/icons.png");
    @Nullable
    private static AttackIndicatorStatus attackIndicator = null;

    public static EventResult onBeforeRenderGuiLayer(Minecraft minecraft, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!((ClientConfig)SwordBlockingMechanics.CONFIG.get(ClientConfig.class)).renderParryIndicator) {
            return EventResult.PASS;
        }
        if (attackIndicator == null && SwordBlockingHandler.getParryStrengthScale((Player)minecraft.player) != 0.0) {
            attackIndicator = (AttackIndicatorStatus)minecraft.options.attackIndicator().get();
            minecraft.options.attackIndicator().set((Object)AttackIndicatorStatus.OFF);
        }
        return EventResult.PASS;
    }

    public static RenderGuiLayerEvents.After onAfterRenderGuiLayer(ResourceLocation resourceLocation) {
        return (minecraft, guiGraphics, deltaTracker) -> AttackIndicatorInGuiHandler.onAfterRenderGuiLayer(resourceLocation, minecraft, guiGraphics, deltaTracker);
    }

    public static void onAfterRenderGuiLayer(ResourceLocation resourceLocation, Minecraft minecraft, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (attackIndicator != null) {
            minecraft.options.attackIndicator().set((Object)attackIndicator);
            attackIndicator = null;
            int screenWidth = guiGraphics.guiWidth();
            int screenHeight = guiGraphics.guiHeight();
            double parryStrengthScale = Math.abs(SwordBlockingHandler.getParryStrengthScale((Player)minecraft.player));
            if (resourceLocation.equals((Object)RenderGuiLayerEvents.CROSSHAIR) && minecraft.options.attackIndicator().get() == AttackIndicatorStatus.CROSSHAIR) {
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                int posX = screenWidth / 2 - 8;
                int posY = screenHeight / 2 - 7 + 16;
                int textureHeight = (int)(parryStrengthScale * 15.0);
                guiGraphics.blit(GUI_ICONS_LOCATION, posX, posY, 54, 0, 16, 14);
                guiGraphics.blit(GUI_ICONS_LOCATION, posX, posY + 14 - textureHeight, 70, 14 - textureHeight, 16, textureHeight);
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableBlend();
            } else if (resourceLocation.equals((Object)RenderGuiLayerEvents.HOTBAR) && minecraft.options.attackIndicator().get() == AttackIndicatorStatus.HOTBAR) {
                RenderSystem.enableBlend();
                int posX = minecraft.player.getMainArm() == HumanoidArm.LEFT ? screenWidth / 2 - 91 - 22 : screenWidth / 2 + 91 + 6;
                int posY = screenHeight - 20;
                int textureHeight = (int)(parryStrengthScale * 19.0);
                guiGraphics.blit(GUI_ICONS_LOCATION, posX, posY, 0, 0, 18, 18);
                guiGraphics.blit(GUI_ICONS_LOCATION, posX, posY + 18 - textureHeight, 18, 18 - textureHeight, 18, textureHeight);
                RenderSystem.disableBlend();
            }
        }
    }
}

