/*
 * Decompiled with CFR 0.152.
 */
package fuzs.swordblockingmechanics.capability;

import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import fuzs.swordblockingmechanics.SwordBlockingMechanics;
import fuzs.swordblockingmechanics.config.ServerConfig;
import fuzs.swordblockingmechanics.handler.SwordBlockingHandler;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class ParryCooldownCapability
extends CapabilityComponent<Player> {
    private int cooldownTicks;

    public double getCooldownProgress() {
        return Mth.clamp((double)(1.0 - (double)this.cooldownTicks / (double)((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).parryWindow), (double)0.0, (double)1.0);
    }

    public void resetCooldownTicks() {
        if (this.cooldownTicks <= 0) {
            int currentUseDuration = 72000 - ((Player)this.getHolder()).getUseItemRemainingTicks();
            this.setCooldownTicks(Math.min(currentUseDuration, ((ServerConfig)SwordBlockingMechanics.CONFIG.get(ServerConfig.class)).parryWindow));
        }
    }

    public void tick() {
        if (this.cooldownTicks > 0 && !SwordBlockingHandler.isActiveItemStackBlocking((Player)this.getHolder())) {
            this.setCooldownTicks(this.cooldownTicks - 2);
        }
    }

    private void setCooldownTicks(int cooldownTicks) {
        if (this.cooldownTicks != cooldownTicks) {
            this.cooldownTicks = cooldownTicks;
            this.setChanged();
        }
    }

    public boolean isCooldownActive() {
        return this.getCooldownProgress() < 1.0;
    }
}

