/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mods.railcraft.api.core.NetworkSerializable;
import mods.railcraft.world.module.Module;
import mods.railcraft.world.module.SharedModule;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class ModuleDispatcher
implements NetworkSerializable,
INBTSerializable<CompoundTag> {
    private final Map<String, Module> moduleByName = new HashMap<String, Module>();
    private final Map<Class<?>, Module> moduleByType = new HashMap();

    public <T extends Module> T registerModule(String name, T module) {
        if (this.moduleByName.put(name, module) != null) {
            throw new IllegalStateException("Module already registered with name: " + name);
        }
        Class<?> clazz = module.getClass();
        do {
            if (clazz.isAnnotationPresent(SharedModule.class) || this.moduleByType.put(clazz, module) == null) continue;
            throw new IllegalStateException("Module already registered with type: " + clazz.getName());
        } while (Module.class.isAssignableFrom(clazz = clazz.getSuperclass()));
        return module;
    }

    public <T> Optional<T> getModule(Class<T> type) {
        return Optional.ofNullable(this.moduleByType.get(type));
    }

    public void serverTick() {
        this.moduleByName.values().forEach(Module::serverTick);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf out) {
        out.writeMap(this.moduleByName, FriendlyByteBuf::writeUtf, (buf, module) -> module.writeToBuf((RegistryFriendlyByteBuf)buf));
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf in) {
        int size = in.readVarInt();
        for (int i = 0; i < size; ++i) {
            String name = in.readUtf();
            Module module = this.moduleByName.get(name);
            if (module == null) {
                throw new IllegalStateException("Missing module: " + name);
            }
            module.readFromBuf(in);
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.moduleByName.forEach((name, module) -> tag.put(name, (Tag)module.serializeNBT(provider)));
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        if (tag.isEmpty()) {
            return;
        }
        this.moduleByName.forEach((name, module) -> {
            CompoundTag moduleTag = tag.getCompound(name);
            if (!moduleTag.isEmpty()) {
                module.deserializeNBT(provider, moduleTag);
            }
        });
    }
}

