/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.material.steam;

import mods.railcraft.util.FuelUtil;
import mods.railcraft.world.level.material.FuelProvider;
import mods.railcraft.world.level.material.StandardTank;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidFuelProvider
implements FuelProvider {
    private final StandardTank fuelTank;

    public FluidFuelProvider(StandardTank fuelTank) {
        this.fuelTank = fuelTank;
    }

    @Override
    public float getHeatStep() {
        return 0.05f;
    }

    @Override
    public float consumeFuel() {
        FluidStack fuel = this.fuelTank.internalDrain(1000, IFluidHandler.FluidAction.SIMULATE);
        if (fuel.isEmpty()) {
            return 0.0f;
        }
        float heatValue = FuelUtil.getFuelValueForSize(fuel);
        if (heatValue > 0.0f) {
            this.fuelTank.internalDrain(1000, IFluidHandler.FluidAction.EXECUTE);
        }
        return heatValue;
    }
}

