/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.levelgen.structure;

import java.util.Optional;
import mods.railcraft.world.level.levelgen.structure.GeodeStructurePiece;
import mods.railcraft.world.level.levelgen.structure.RailcraftStructureTypes;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class GeodeStructure
extends Structure {
    public GeodeStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        int x = context.chunkPos().getBlockX(9);
        int z = context.chunkPos().getBlockZ(9);
        for (Holder holder : context.biomeSource().getBiomesWithin(x, context.chunkGenerator().getSeaLevel(), z, 29, context.randomState().sampler())) {
            if (holder.is(BiomeTags.IS_DEEP_OCEAN)) continue;
            return Optional.empty();
        }
        return GeodeStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, structurePiecesBuilder -> this.generatePieces((StructurePiecesBuilder)structurePiecesBuilder, context));
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        ChunkGenerator generator = context.chunkGenerator();
        LevelHeightAccessor heightAccessor = context.heightAccessor();
        WorldgenRandom random = context.random();
        RandomState state = context.randomState();
        int x = chunkPos.getBlockX(random.nextInt(16));
        int z = chunkPos.getBlockZ(random.nextInt(16));
        int y = generator.getBaseHeight(x, z, Heightmap.Types.OCEAN_FLOOR, heightAccessor, state);
        builder.addPiece((StructurePiece)new GeodeStructurePiece(x, y - 6, z));
    }

    public StructureType<?> type() {
        return (StructureType)RailcraftStructureTypes.GEODE.get();
    }
}

