/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import mods.railcraft.world.level.levelgen.feature.configuration.QuarriedConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class QuarriedFeature
extends Feature<QuarriedConfiguration> {
    private static final int DISTANCE_OUTER_SQ = 64;

    public QuarriedFeature(Codec<QuarriedConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<QuarriedConfiguration> context) {
        BlockState existingState;
        int distSq;
        int y;
        int z;
        int x;
        BlockPos origin;
        WorldGenLevel level = context.level();
        if (!level.getBlockState(origin = level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, context.origin()).below(3)).is(BlockTags.DIRT)) {
            return false;
        }
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        boolean clearTop = true;
        for (x = -8; x < 8; ++x) {
            for (z = -8; z < 8; ++z) {
                for (y = 1; y < 4 && y + origin.getY() < level.getHeight() - 1; ++y) {
                    distSq = x * x + z * z;
                    if (distSq > 64) continue;
                    currentPos.set(origin.getX() + x, origin.getY() + y, origin.getZ() + z);
                    if (!(level.getBlockState((BlockPos)currentPos).getBlock() instanceof LiquidBlock)) continue;
                    clearTop = false;
                }
            }
        }
        if (clearTop) {
            for (x = -8; x < 8; ++x) {
                block4: for (z = -8; z < 8; ++z) {
                    for (y = 1; y < 4 && y + origin.getY() < level.getHeight() - 1; ++y) {
                        distSq = x * x + z * z;
                        if (distSq > 64) continue;
                        currentPos.set(origin.getX() + x, origin.getY() + y, origin.getZ() + z);
                        existingState = level.getBlockState((BlockPos)currentPos);
                        if (!this.placeAir(existingState, level, (BlockPos)currentPos)) continue block4;
                    }
                }
            }
        }
        for (x = -8; x < 8; ++x) {
            for (z = -8; z < 8; ++z) {
                for (y = -8; y < 1 && y + origin.getY() < level.getHeight() - 1; ++y) {
                    distSq = x * x + z * z + y * y;
                    if (distSq > 64) continue;
                    currentPos.set(origin.getX() + x, origin.getY() + y, origin.getZ() + z);
                    existingState = level.getBlockState((BlockPos)currentPos);
                    this.placeState(existingState, level, (BlockPos)currentPos, context.random(), (QuarriedConfiguration)context.config());
                }
            }
        }
        return true;
    }

    private boolean placeAir(BlockState existingState, WorldGenLevel level, BlockPos blockPos) {
        BlockPos above = blockPos.above();
        if (!level.isEmptyBlock(above) || existingState.getBlock() instanceof LiquidBlock) {
            return false;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos target = above.relative(direction);
            if (level.isEmptyBlock(target)) continue;
            return false;
        }
        level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 2);
        return true;
    }

    private void placeState(BlockState existingState, WorldGenLevel level, BlockPos blockPos, RandomSource random, QuarriedConfiguration config) {
        BlockPos above = blockPos.above();
        if (level.getBlockState(above).is(Blocks.SHORT_GRASS)) {
            level.setBlock(above, Blocks.AIR.defaultBlockState(), 2);
        }
        if (config.targetProvider().test(existingState, random)) {
            level.setBlock(blockPos, config.stateProvider().getState(random, blockPos), 2);
        }
    }
}

