/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import it.unimi.dsi.fastutil.chars.CharList;
import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.world.inventory.BlastFurnaceMenu;
import mods.railcraft.world.level.block.FurnaceMultiblockBlock;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.multiblock.BlockPredicate;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockBlockEntity;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockPattern;
import mods.railcraft.world.module.BlastFurnaceModule;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class BlastFurnaceBlockEntity
extends MultiblockBlockEntity<BlastFurnaceBlockEntity, Void> {
    private static final MultiblockPattern<Void> PATTERN = (MultiblockPattern)Util.make(() -> {
        BlockPredicate bricks = BlockPredicate.of(RailcraftBlocks.BLAST_FURNACE_BRICKS);
        BlockPredicate lava = BlockPredicate.ofFluidTag((TagKey<Fluid>)FluidTags.LAVA);
        List<CharList> middle = List.of(CharList.of((char)'B', (char)'B', (char)'B'), CharList.of((char)'B', (char)'A', (char)'B'), CharList.of((char)'B', (char)'B', (char)'B'));
        return MultiblockPattern.builder(2, 1, 2).layer(List.of(CharList.of((char)'B', (char)'B', (char)'B'), CharList.of((char)'B', (char)'B', (char)'B'), CharList.of((char)'B', (char)'B', (char)'B'))).layer(middle).layer(middle).layer(List.of(CharList.of((char)'B', (char)'W', (char)'B'), CharList.of((char)'W', (char)'B', (char)'W'), CharList.of((char)'B', (char)'W', (char)'B'))).predicate('B', bricks).predicate('W', bricks).predicate('A', lava.or(BlockPredicate.AIR)).build();
    });
    private final BlastFurnaceModule blastFurnaceModule;
    private int fuelMoveTicks;

    public BlastFurnaceBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.BLAST_FURNACE.get(), blockPos, blockState, BlastFurnaceBlockEntity.class, PATTERN);
        this.blastFurnaceModule = this.moduleDispatcher.registerModule("blast_furnace", new BlastFurnaceModule(this));
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, BlastFurnaceBlockEntity blockEntity) {
        blockEntity.serverTick();
        blockEntity.moduleDispatcher.serverTick();
        blockEntity.getMasterBlockEntity().ifPresent(master -> {
            boolean lit = master.blastFurnaceModule.isBurning();
            if (lit != (Boolean)blockState.getValue((Property)FurnaceMultiblockBlock.LIT)) {
                level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)FurnaceMultiblockBlock.LIT, (Comparable)Boolean.valueOf(lit)));
            }
            if (blockEntity.fuelMoveTicks++ >= 128) {
                blockEntity.fuelMoveTicks = 0;
                blockEntity.findAdjacentContainers().moveOneItemTo(master.getBlastFurnaceModule().getFuelContainer(), master.blastFurnaceModule::isFuel);
            }
        });
    }

    public BlastFurnaceModule getBlastFurnaceModule() {
        return this.blastFurnaceModule;
    }

    @Override
    protected boolean isBlockEntity(MultiblockPattern.Element element) {
        return element.marker() == 'B' || element.marker() == 'W';
    }

    @Override
    protected void membershipChanged(@Nullable MultiblockBlockEntity.Membership<BlastFurnaceBlockEntity> membership) {
        if (membership == null) {
            this.level.setBlock(this.getBlockPos(), (BlockState)((BlockState)this.getBlockState().setValue((Property)FurnaceMultiblockBlock.WINDOW, (Comparable)Boolean.valueOf(false))).setValue((Property)FurnaceMultiblockBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            Containers.dropContents((Level)this.level, (BlockPos)this.getBlockPos(), (Container)this.blastFurnaceModule);
        } else {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)FurnaceMultiblockBlock.WINDOW, (Comparable)Boolean.valueOf(membership.patternElement().marker() == 'W')), 3);
        }
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new BlastFurnaceMenu(id, inventory, this);
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)Translations.Container.BLAST_FURNACE);
    }

    @Nullable
    public IItemHandler getItemCap(@Nullable Direction side) {
        return this.getMasterBlockEntity().map(BlastFurnaceBlockEntity::getBlastFurnaceModule).map(BlastFurnaceModule::getItemHandler).orElse(null);
    }
}

