/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.advancements.RailcraftCriteriaTriggers;
import mods.railcraft.advancements.SpikeMaulUseTrigger;
import mods.railcraft.api.item.SpikeMaulTarget;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.level.block.track.TrackBlock;
import mods.railcraft.world.level.block.track.TrackTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;

public class SpikeMaulItem
extends TieredItem {
    private final ItemAttributeModifiers defaultModifiers;

    public SpikeMaulItem(float attackDamage, float attackSpeed, Tier tier, Item.Properties properties) {
        super(tier, properties.durability(tier.getUses()));
        float attackDamageWithBonus = attackDamage + tier.getAttackDamageBonus();
        this.defaultModifiers = ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)attackDamageWithBonus, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.defaultModifiers;
    }

    public InteractionResult useOn(UseOnContext context) {
        List variants;
        BlockPos blockPos;
        Level level = context.getLevel();
        BlockState existingBlockState = level.getBlockState(blockPos = context.getClickedPos());
        if (!BaseRailBlock.isRail((BlockState)existingBlockState)) {
            return InteractionResult.PASS;
        }
        RailShape railShape = TrackBlock.getRailShapeRaw(existingBlockState);
        if (railShape.isAscending()) {
            return InteractionResult.PASS;
        }
        Block block = existingBlockState.getBlock();
        if (block instanceof SpikeMaulTarget) {
            SpikeMaulTarget target = (SpikeMaulTarget)block;
            variants = target.getSpikeMaulVariants();
        } else if (existingBlockState.is(Blocks.RAIL)) {
            variants = ((TrackType)TrackTypes.IRON.get()).getSpikeMaulVariants();
        } else {
            return InteractionResult.PASS;
        }
        if (variants.isEmpty()) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        if (player.isCrouching()) {
            variants = Lists.reverse(variants);
        }
        ArrayDeque targets = new ArrayDeque(variants);
        Supplier first = (Supplier)targets.getFirst();
        Supplier found = null;
        do {
            Supplier each;
            if (!existingBlockState.is((Block)(each = (Supplier)targets.removeFirst()).get())) continue;
            found = targets.isEmpty() ? first : (Supplier)targets.getFirst();
            break;
        } while (!targets.isEmpty());
        if (found == null) {
            return InteractionResult.PASS;
        }
        if (!level.setBlockAndUpdate(blockPos, ((Block)found.get()).getStateForPlacement(new BlockPlaceContext(context)))) {
            level.setBlockAndUpdate(blockPos, existingBlockState);
            return InteractionResult.FAIL;
        }
        InteractionHand hand = context.getHand();
        ItemStack heldStack = player.getItemInHand(hand);
        BlockState newBlockState = level.getBlockState(blockPos);
        SoundType soundtype = newBlockState.getSoundType((LevelReader)level, blockPos, (Entity)player);
        level.playSound(player, blockPos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ((SpikeMaulUseTrigger)((Object)RailcraftCriteriaTriggers.SPIKE_MAUL_USE.value())).trigger((ServerPlayer)player, heldStack, serverLevel, blockPos);
            heldStack.hurtAndBreak(1, serverLevel, (LivingEntity)player, item -> player.onEquippedItemBroken(item, LivingEntity.getSlotForHand((InteractionHand)hand)));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public boolean doesSneakBypassUse(ItemStack itemStack, LevelReader level, BlockPos blockPos, Player player) {
        return true;
    }

    public boolean canDisableShield(ItemStack itemStack, ItemStack shieldStack, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag isAdvanced) {
        components.add((Component)Component.translatable((String)Translations.Tips.SPIKE_MAUL).withStyle(ChatFormatting.GRAY));
    }
}

