/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import mods.railcraft.api.item.ActivationBlockingItem;
import mods.railcraft.world.item.component.PairToolComponent;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ActivationBlockingItem
public abstract class PairingToolItem<T, P>
extends Item {
    private static final Logger logger = LogUtils.getLogger();

    public PairingToolItem(Item.Properties properties) {
        super(properties);
    }

    protected abstract Class<T> targetType();

    protected abstract Class<P> peerType();

    public final InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        GlobalPos targetPos = PairingToolItem.getTargetPos(itemStack).orElse(null);
        if (targetPos != null) {
            if (targetPos.pos().equals((Object)pos)) {
                this.displayMessageForState(player, State.ABANDONED);
                return InteractionResult.CONSUME;
            }
            if (targetPos.dimension().compareTo(level.dimension()) != 0) {
                ServerLevel dimension = level.getServer().getLevel(targetPos.dimension());
                if (dimension != null) {
                    this.abandon(PairingToolItem.getBlockEntity((BlockGetter)dimension, targetPos.pos(), this.targetType()));
                }
                PairingToolItem.clearTargetPos(itemStack);
                targetPos = null;
            }
        }
        if (targetPos == null) {
            T target = PairingToolItem.getBlockEntity((BlockGetter)level, pos, this.targetType());
            if (target == null) {
                this.displayMessageForState(player, State.INVALID_TARGET);
                return InteractionResult.FAIL;
            }
            Result result = this.begin(target);
            player.displayClientMessage(result.message(), true);
            if (result.success()) {
                PairingToolItem.setTargetPos(itemStack, GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos));
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        T targetEntity = PairingToolItem.getBlockEntity((BlockGetter)level, targetPos.pos(), this.targetType());
        if (player.isShiftKeyDown()) {
            this.abandon(targetEntity);
            this.displayMessageForState(player, State.ABANDONED);
            PairingToolItem.clearTargetPos(itemStack);
            return InteractionResult.CONSUME;
        }
        if (targetEntity == null) {
            this.displayMessageForState(player, State.LOST_TARGET);
            PairingToolItem.clearTargetPos(itemStack);
            return InteractionResult.FAIL;
        }
        P peerEntity = PairingToolItem.getBlockEntity((BlockGetter)level, pos, this.peerType());
        if (peerEntity == null) {
            this.displayMessageForState(player, State.INVALID_PEER);
            return InteractionResult.FAIL;
        }
        if (targetEntity == peerEntity) {
            throw new IllegalStateException("Target entity is the same as the peer entity.");
        }
        Result result = this.complete(targetEntity, peerEntity);
        player.displayClientMessage(result.message(), true);
        PairingToolItem.clearTargetPos(itemStack);
        return result.success() ? InteractionResult.CONSUME : InteractionResult.FAIL;
    }

    private void displayMessageForState(Player player, State state) {
        player.displayClientMessage(this.getMessageForState(state), true);
    }

    protected abstract Component getMessageForState(State var1);

    protected abstract void abandon(@Nullable T var1);

    protected abstract Result begin(T var1);

    protected abstract Result complete(T var1, P var2);

    @Nullable
    private static <T> T getBlockEntity(BlockGetter getter, BlockPos pos, Class<T> type) {
        BlockEntity entity = getter.getBlockEntity(pos);
        return type.isInstance(entity) ? (T)type.cast(entity) : null;
    }

    public static Optional<GlobalPos> getTargetPos(ItemStack itemStack) {
        if (itemStack.has(RailcraftDataComponents.PAIR_TOOL)) {
            return Optional.of(((PairToolComponent)itemStack.get(RailcraftDataComponents.PAIR_TOOL)).peerPos());
        }
        return Optional.empty();
    }

    public static void setTargetPos(ItemStack itemStack, GlobalPos peerPos) {
        itemStack.set(RailcraftDataComponents.PAIR_TOOL, (Object)new PairToolComponent(peerPos));
    }

    public static void clearTargetPos(ItemStack itemStack) {
        itemStack.remove(RailcraftDataComponents.PAIR_TOOL);
    }

    public static <T> boolean checkAbandonPairing(GlobalPos signalPos, Player player, ServerLevel level, Runnable stopLinking) {
        if (signalPos.dimension().compareTo(level.dimension()) != 0) {
            return true;
        }
        if (player.isShiftKeyDown()) {
            stopLinking.run();
            return true;
        }
        return false;
    }

    protected static enum State {
        ABANDONED,
        LOST_TARGET,
        INVALID_TARGET,
        INVALID_PEER;

    }

    protected record Result(boolean success, Component message) {
        public static Result success(Component message) {
            return new Result(true, message);
        }

        public static Result failure(Component message) {
            return new Result(false, message);
        }
    }
}

