/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle.locomotive;

import java.util.Set;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.charge.ChargeCartStorageImpl;
import mods.railcraft.sounds.RailcraftSoundEvents;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.inventory.ElectricLocomotiveMenu;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.TicketItem;
import mods.railcraft.world.item.component.LocomotiveEnergyComponent;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class ElectricLocomotive
extends Locomotive
implements WorldlyContainer {
    private static final int ACTUAL_FUEL_GAIN_PER_REQUEST = 20;
    private static final int FUEL_PER_REQUEST = 1;
    private static final int CHARGE_USE_PER_REQUEST = 80;
    public static final int MAX_CHARGE = 5000;
    private static final int SLOT_TICKET = 0;
    private static final int[] SLOTS = ContainerTools.buildSlotArray(0, 1);
    private static final Set<Locomotive.Mode> ALLOWED_MODES = Set.of(Locomotive.Mode.RUNNING, Locomotive.Mode.SHUTDOWN);
    private final Container ticketInventory = new ContainerMapper((Container)this, 0, 2).ignoreItemChecks();
    private ChargeCartStorageImpl cartStorage = new ChargeCartStorageImpl(5000);

    public ElectricLocomotive(EntityType<?> type, Level level) {
        super(type, level);
    }

    public ElectricLocomotive(ItemStack itemStack, double x, double y, double z, ServerLevel serverLevel) {
        super(itemStack, (EntityType)RailcraftEntityTypes.ELECTRIC_LOCOMOTIVE.get(), x, y, z, serverLevel);
        this.loadFromItemStack(itemStack);
    }

    @Override
    public Set<Locomotive.Mode> getSupportedModes() {
        return ALLOWED_MODES;
    }

    @Override
    protected DyeColor getDefaultPrimaryColor() {
        return DyeColor.YELLOW;
    }

    @Override
    protected DyeColor getDefaultSecondaryColor() {
        return DyeColor.BLACK;
    }

    @Override
    public SoundEvent getWhistleSound() {
        return (SoundEvent)RailcraftSoundEvents.ELECTRIC_WHISTLE.get();
    }

    @Override
    protected int getIdleFuelUse() {
        return 0;
    }

    @Override
    public int retrieveFuel() {
        if (this.cartStorage.getEnergyStored() > 80) {
            this.cartStorage.extractEnergy(80, false);
            return 20;
        }
        return 0;
    }

    @Override
    protected Item getDropItem() {
        return (Item)RailcraftItems.ELECTRIC_LOCOMOTIVE.get();
    }

    @Override
    public float getOptimalDistance(RollingStock cart) {
        return 0.92f;
    }

    @Override
    protected Container ticketContainer() {
        return this.ticketInventory;
    }

    @Override
    public int getContainerSize() {
        return 2;
    }

    public int[] getSlotsForFace(Direction side) {
        return SLOTS;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction side) {
        return this.canPlaceItem(slot, stack);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction side) {
        return slot == 0;
    }

    public boolean canPlaceItem(int slot, @Nullable ItemStack stack) {
        if (slot == 0) {
            return TicketItem.FILTER.test(stack);
        }
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        this.cartStorage.tick((AbstractMinecart)this);
    }

    protected void moveAlongTrack(BlockPos pos, BlockState state) {
        super.moveAlongTrack(pos, state);
        this.cartStorage.tickOnTrack((AbstractMinecart)this, pos);
    }

    @Override
    public boolean needsFuel() {
        float charge = (float)this.cartStorage.getEnergyStored() / (float)this.cartStorage.getMaxEnergyStored();
        return (double)charge < 0.8;
    }

    public IEnergyStorage getBatteryCart() {
        return this.cartStorage;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.cartStorage.receiveEnergy(tag.getInt("energy"), false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("energy", this.cartStorage.getEnergyStored());
    }

    @Override
    protected void loadFromItemStack(ItemStack itemStack) {
        super.loadFromItemStack(itemStack);
        if (itemStack.has(RailcraftDataComponents.LOCOMOTIVE_ENERGY)) {
            this.cartStorage.receiveEnergy(((LocomotiveEnergyComponent)itemStack.get(RailcraftDataComponents.LOCOMOTIVE_ENERGY)).energy(), false);
        }
    }

    @Override
    public ItemStack getPickResult() {
        ItemStack itemStack = super.getPickResult();
        itemStack.set(RailcraftDataComponents.LOCOMOTIVE_ENERGY, (Object)new LocomotiveEnergyComponent(this.cartStorage.getEnergyStored()));
        return itemStack;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new ElectricLocomotiveMenu(id, playerInventory, this);
    }
}

