/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.carts.Linkable;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.carts.Side;
import mods.railcraft.api.carts.Train;
import mods.railcraft.api.carts.TunnelBoreHead;
import mods.railcraft.api.container.manipulator.SlotAccessor;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.datamaps.RailcraftDataMaps;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.util.ModEntitySelector;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.util.container.StackFilter;
import mods.railcraft.world.damagesource.RailcraftDamageSources;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.entity.vehicle.RailcraftMinecart;
import mods.railcraft.world.entity.vehicle.TunnelBorePart;
import mods.railcraft.world.inventory.TunnelBoreMenu;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.tunnelbore.TunnelBoreItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.Nullable;

public class TunnelBore
extends RailcraftMinecart
implements Linkable {
    public static final float SPEED = 0.03f;
    public static final float LENGTH = 6.2f;
    public static final float WIDTH = 3.0f;
    public static final float HEIGHT = 3.0f;
    public static final int MAX_FILL_DEPTH = 10;
    public static final int FAIL_DELAY = 200;
    public static final int STANDARD_DELAY = 5;
    public static final int LAYER_DELAY = 40;
    public static final int BALLAST_DELAY = 10;
    public static final int FUEL_CONSUMPTION = 12;
    public static final float HARDNESS_MULTIPLIER = 8.0f;
    private static final EntityDataAccessor<Boolean> HAS_FUEL = SynchedEntityData.defineId(TunnelBore.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.defineId(TunnelBore.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Direction> FACING = SynchedEntityData.defineId(TunnelBore.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<ItemStack> BORE_HEAD = SynchedEntityData.defineId(TunnelBore.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private final ContainerMapper fuelContainer = ContainerMapper.make((Container)this, 1, 6).addFilters(StackFilter.FUEL);
    private final ContainerMapper ballastContainer = ContainerMapper.make((Container)this, 7, 9).addFilters(StackFilter.BALLAST);
    private final ContainerMapper trackContainer = ContainerMapper.make((Container)this, 16, 9).addFilters(StackFilter.TRACK);
    protected int delay;
    protected boolean placeRail;
    protected boolean placeBallast;
    protected boolean boreLayer;
    protected int boreRotationAngle;
    private boolean active;
    private int clock;
    private int burnTime;
    private int fuel;
    private final boolean constructed;
    private final TunnelBorePart[] parts;
    private final List<ContainerMapper> containers;

    public TunnelBore(EntityType<TunnelBore> type, Level level) {
        this(level, 0.0, 0.0, 0.0, Direction.SOUTH);
    }

    public TunnelBore(Level level, double x, double y, double z, Direction facing) {
        super((EntityType<TunnelBore>)((EntityType)RailcraftEntityTypes.TUNNEL_BORE.get()), x, y, z, level);
        this.setFacing(facing);
        float headW = 1.5f;
        float headH = 2.6f;
        float headSO = 0.7f;
        this.parts = new TunnelBorePart[]{new TunnelBorePart(this, headW, headH, 1.85f, -headSO), new TunnelBorePart(this, headW, headH, 1.85f, headSO), new TunnelBorePart(this, headW, headH, 2.3f, -headSO), new TunnelBorePart(this, headW, headH, 2.3f, headSO), new TunnelBorePart(this, 2.0f, 1.9f, 0.6f), new TunnelBorePart(this, 1.6f, 1.4f, -1.0f), new TunnelBorePart(this, 1.6f, 1.4f, -2.2f)};
        this.constructed = true;
        this.containers = List.of(this.fuelContainer, this.ballastContainer, this.trackContainer);
        this.setId(ENTITY_COUNTER.getAndAdd(this.parts.length + 1) + 1);
    }

    public void setId(int id) {
        super.setId(id);
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].setId(id + i + 1);
        }
    }

    @Override
    public ItemStack getPickResult() {
        return ((TunnelBoreItem)RailcraftItems.TUNNEL_BORE.get()).getDefaultInstance();
    }

    public boolean canHeadHarvestBlock(ItemStack head, BlockState targetState) {
        return !head.isEmpty() && (!targetState.requiresCorrectToolForDrops() || head.isCorrectToolForDrops(targetState));
    }

    private boolean isMineableBlock(BlockState blockState) {
        return (Boolean)RailcraftConfig.SERVER.boreMinesAllBlocks.get() != false || blockState.is(RailcraftTags.Blocks.TUNNEL_BORE_MINEABLE_BLOCKS);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_FUEL, (Object)false);
        builder.define(MOVING, (Object)false);
        builder.define(BORE_HEAD, (Object)ItemStack.EMPTY);
        builder.define(FACING, (Object)Direction.NORTH);
    }

    public boolean isMinecartPowered() {
        return (Boolean)this.entityData.get(HAS_FUEL);
    }

    public void setMinecartPowered(boolean powered) {
        this.entityData.set(HAS_FUEL, (Object)powered);
    }

    /*
     * Unable to fully structure code
     */
    public boolean hurt(DamageSource source, float damage) {
        if (this.level().isClientSide() || this.isRemoved()) {
            return true;
        }
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.markHurt();
        this.setDamage(this.getDamage() + damage * 10.0f);
        this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, source.getEntity());
        var5_3 = source.getEntity();
        if (!(var5_3 instanceof Player)) ** GOTO lbl-1000
        player = (Player)var5_3;
        if (player.getAbilities().instabuild) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = flag = false;
        }
        if (flag || this.getDamage() > 120.0f) {
            this.ejectPassengers();
            if (flag && !this.hasCustomName()) {
                this.remove(Entity.RemovalReason.KILLED);
            } else {
                this.destroy(source);
            }
        }
        return true;
    }

    private void setYaw() {
        int yaw = switch (this.getFacing()) {
            case Direction.NORTH -> 180;
            case Direction.EAST -> 270;
            case Direction.WEST -> 90;
            default -> 0;
        };
        this.setRot(yaw, this.getXRot());
    }

    public int getContainerSize() {
        return 25;
    }

    public boolean isPushable() {
        return false;
    }

    public void setPos(double x, double y, double z) {
        if (!this.constructed) {
            super.setPos(x, y, z);
            return;
        }
        this.setPosRaw(x, y, z);
        double halfWidth = 1.5;
        double height = this.getBbHeight();
        double len = 3.1f;
        double minX = x;
        double maxX = x;
        double minZ = z;
        double maxZ = z;
        if (this.getFacing() == Direction.WEST || this.getFacing() == Direction.EAST) {
            minX -= len;
            maxX += len;
            minZ -= halfWidth;
            maxZ += halfWidth;
        } else {
            minX -= halfWidth;
            maxX += halfWidth;
            minZ -= len;
            maxZ += len;
        }
        this.setBoundingBox(new AABB(minX, y, minZ, maxX, y + height, maxZ));
    }

    public void tick() {
        ++this.clock;
        if (!this.level().isClientSide()) {
            if (this.clock % 64 == 0) {
                this.forceUpdateBoreHead();
                this.setMinecartPowered(false);
                this.setMoving(false);
            }
            this.stockBallast();
            this.stockTracks();
        }
        super.tick();
        for (TunnelBorePart part : this.parts) {
            part.tick();
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.updateFuel();
            if (this.hasFuel() && this.getDelay() == 0) {
                BlockPos targetPos;
                this.setActive(true);
                RailShape dir = RailShape.NORTH_SOUTH;
                if (this.getFacing() == Direction.WEST || this.getFacing() == Direction.EAST) {
                    dir = RailShape.EAST_WEST;
                }
                if (this.getDelay() == 0) {
                    float offset = 1.5f;
                    targetPos = new BlockPos((Vec3i)this.getPositionAhead(offset)).below();
                    if (this.placeBallast) {
                        boolean placed = this.placeBallast(targetPos);
                        if (placed) {
                            this.setDelay(5);
                        } else {
                            this.setDelay(200);
                            this.setActive(false);
                        }
                        this.placeBallast = false;
                    } else if (!Block.canSupportRigidBlock((BlockGetter)this.level(), (BlockPos)targetPos)) {
                        this.placeBallast = true;
                        this.setDelay(10);
                    }
                }
                if (this.getDelay() == 0) {
                    float offset = 0.8f;
                    targetPos = new BlockPos((Vec3i)this.getPositionAhead(offset));
                    BlockState existingState = this.level().getBlockState(targetPos);
                    if (this.placeRail) {
                        boolean placed = this.placeTrack(targetPos, existingState, dir);
                        if (placed) {
                            this.setDelay(5);
                        } else {
                            this.setDelay(200);
                            this.setActive(false);
                        }
                        this.placeRail = false;
                    } else if (BaseRailBlock.isRail((BlockState)existingState)) {
                        if (dir != TrackUtil.getTrackDirection((BlockGetter)this.level(), targetPos, (AbstractMinecart)this)) {
                            TrackUtil.setRailShape(this.level(), targetPos, dir);
                            this.setDelay(5);
                        }
                    } else if (existingState.isAir() || existingState.is(Blocks.TORCH)) {
                        this.placeRail = true;
                        this.setDelay(5);
                    } else {
                        this.setDelay(200);
                        this.setActive(false);
                    }
                }
                if (this.getDelay() == 0) {
                    float offset = 3.3f;
                    targetPos = new BlockPos((Vec3i)this.getPositionAhead(offset));
                    if (this.boreLayer) {
                        boolean bored = this.boreLayer(targetPos, dir);
                        if (bored) {
                            this.setDelay(40);
                        } else {
                            this.setDelay(200);
                            this.setActive(false);
                        }
                        this.boreLayer = false;
                    } else if (this.checkForLava(targetPos, dir)) {
                        this.setDelay(200);
                        this.setActive(false);
                    } else {
                        this.setDelay(Mth.ceil((double)this.getLayerHardness(targetPos, dir)));
                        if (this.getDelay() != 0) {
                            this.boreLayer = true;
                        }
                    }
                }
            }
            if (this.isMinecartPowered()) {
                BlockPos headPos = this.getPositionAhead(3.3);
                double size = 0.8;
                List<LivingEntity> entities = EntitySearcher.findLiving().and(ModEntitySelector.KILLABLE).box(builder -> builder.setBoundsToPoint((Vec3i)headPos).inflateHorizontally(size).raiseCeiling(2.0).build()).list(this.level());
                entities.forEach(e -> e.hurt((DamageSource)RailcraftDamageSources.bore(this.level().registryAccess()), 2.0f));
                ItemStack head = this.getItem(0);
                if (!head.isEmpty()) {
                    head.hurtAndBreak(entities.size(), serverLevel, MinecartUtil.getFakePlayer((AbstractMinecart)this), __ -> {});
                }
            }
            this.setMoving(this.hasFuel() && this.getDelay() == 0);
            if (this.getDelay() > 0) {
                this.setDelay(this.getDelay() - 1);
            }
        }
        Vec3 motion = this.getDeltaMovement();
        if (this.isMoving()) {
            float factorX = -Mth.sin((float)((float)Math.toRadians(this.getYRot())));
            float factorZ = Mth.cos((float)((float)Math.toRadians(this.getYRot())));
            this.setDeltaMovement(0.03f * factorX, motion.y(), 0.03f * factorZ);
        } else {
            this.setDeltaMovement(0.0, motion.y(), 0.0);
        }
        this.emitParticles();
        if (this.isMinecartPowered()) {
            this.boreRotationAngle += 5;
        }
    }

    public float getMaxCartSpeedOnRail() {
        return 0.03f;
    }

    @Override
    protected Item getDropItem() {
        return (Item)RailcraftItems.TUNNEL_BORE.get();
    }

    private void updateFuel() {
        if (!this.level().isClientSide()) {
            if (this.isMinecartPowered()) {
                this.spendFuel();
            }
            this.stockFuel();
            if (this.outOfFuel()) {
                this.addFuel();
            }
            this.setMinecartPowered(this.hasFuel() && this.isActive());
        }
    }

    protected BlockPos getPositionAhead(double offset) {
        double x = this.getX();
        double z = this.getZ();
        if (this.getFacing() == Direction.EAST) {
            x += offset;
        } else if (this.getFacing() == Direction.WEST) {
            x -= offset;
        }
        if (this.getFacing() == Direction.NORTH) {
            z -= offset;
        } else if (this.getFacing() == Direction.SOUTH) {
            z += offset;
        }
        return BlockPos.containing((double)x, (double)this.getY(), (double)z);
    }

    protected double getOffsetX(double x, double forwardOffset, double sideOffset) {
        return switch (this.getFacing()) {
            case Direction.NORTH -> x + sideOffset;
            case Direction.SOUTH -> x - sideOffset;
            case Direction.EAST -> x + forwardOffset;
            case Direction.WEST -> x - forwardOffset;
            default -> x;
        };
    }

    protected double getOffsetZ(double z, double forwardOffset, double sideOffset) {
        return switch (this.getFacing()) {
            case Direction.NORTH -> z - forwardOffset;
            case Direction.SOUTH -> z + forwardOffset;
            case Direction.EAST -> z - sideOffset;
            case Direction.WEST -> z + sideOffset;
            default -> z;
        };
    }

    protected void emitParticles() {
        if (this.isMinecartPowered()) {
            double randomFactor = 0.125;
            double forwardOffset = -0.35;
            double smokeYOffset = 2.8;
            double flameYOffset = 1.1;
            double smokeSideOffset = 0.92;
            double flameSideOffset = 1.14;
            double smokeX1 = this.getX();
            double smokeX2 = this.getX();
            double smokeZ1 = this.getZ();
            double smokeZ2 = this.getZ();
            double flameX1 = this.getX();
            double flameX2 = this.getX();
            double flameZ1 = this.getZ();
            double flameZ2 = this.getZ();
            if (this.getFacing() == Direction.NORTH) {
                smokeX1 += smokeSideOffset;
                smokeX2 -= smokeSideOffset;
                smokeZ1 += forwardOffset;
                smokeZ2 += forwardOffset;
                flameX1 += flameSideOffset;
                flameX2 -= flameSideOffset;
                flameZ1 += forwardOffset + this.random.nextGaussian() * randomFactor;
                flameZ2 += forwardOffset + this.random.nextGaussian() * randomFactor;
            } else if (this.getFacing() == Direction.EAST) {
                smokeX1 -= forwardOffset;
                smokeX2 -= forwardOffset;
                smokeZ1 += smokeSideOffset;
                smokeZ2 -= smokeSideOffset;
                flameX1 -= forwardOffset + this.random.nextGaussian() * randomFactor;
                flameX2 -= forwardOffset + this.random.nextGaussian() * randomFactor;
                flameZ1 += flameSideOffset;
                flameZ2 -= flameSideOffset;
            } else if (this.getFacing() == Direction.SOUTH) {
                smokeX1 += smokeSideOffset;
                smokeX2 -= smokeSideOffset;
                smokeZ1 -= forwardOffset;
                smokeZ2 -= forwardOffset;
                flameX1 += flameSideOffset;
                flameX2 -= flameSideOffset;
                flameZ1 -= forwardOffset + this.random.nextGaussian() * randomFactor;
                flameZ2 -= forwardOffset + this.random.nextGaussian() * randomFactor;
            } else if (this.getFacing() == Direction.WEST) {
                smokeX1 += forwardOffset;
                smokeX2 += forwardOffset;
                smokeZ1 += smokeSideOffset;
                smokeZ2 -= smokeSideOffset;
                flameX1 += forwardOffset + this.random.nextGaussian() * randomFactor;
                flameX2 += forwardOffset + this.random.nextGaussian() * randomFactor;
                flameZ1 += flameSideOffset;
                flameZ2 -= flameSideOffset;
            }
            if (this.random.nextInt(4) == 0) {
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, smokeX1, this.getY() + smokeYOffset, smokeZ1, 0.0, 0.0, 0.0);
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, flameX1, this.getY() + flameYOffset + this.random.nextGaussian() * randomFactor, flameZ1, 0.0, 0.0, 0.0);
            }
            if (this.random.nextInt(4) == 0) {
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, smokeX2, this.getY() + smokeYOffset, smokeZ2, 0.0, 0.0, 0.0);
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, flameX2, this.getY() + flameYOffset + this.random.nextGaussian() * randomFactor, flameZ2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void stockBallast() {
        ItemStack stack = RollingStock.getOrThrow((AbstractMinecart)this).pullItem(this.ballastContainer::canFit);
        if (!stack.isEmpty()) {
            this.ballastContainer.insert(stack);
        }
    }

    protected boolean placeBallast(BlockPos targetPos) {
        if (!Block.canSupportRigidBlock((BlockGetter)this.level(), (BlockPos)targetPos)) {
            return this.ballastContainer.stream().filter(slot -> slot.hasItem() && ContainerTools.getBlockFromStack(slot.item()).builtInRegistryHolder().is(RailcraftTags.Blocks.BALLAST)).findFirst().map(slot -> {
                BlockPos.MutableBlockPos searchPos = targetPos.mutable();
                for (int i = 0; i < 10; ++i) {
                    BlockState state;
                    searchPos.move(Direction.DOWN);
                    if (Block.canSupportRigidBlock((BlockGetter)this.level(), (BlockPos)searchPos)) {
                        state = ContainerTools.getBlockStateFromStack(slot.item(), this.level(), targetPos);
                        if (state == null) continue;
                        slot.extract();
                        this.level().setBlockAndUpdate(targetPos, state);
                        return true;
                    }
                    state = this.level().getBlockState((BlockPos)searchPos);
                    if (state.isAir() || state.liquid()) continue;
                    LevelUtil.playerRemoveBlock(this.level(), searchPos.immutable(), (Player)MinecartUtil.getFakePlayer((AbstractMinecart)this), this.level().getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (Boolean)RailcraftConfig.SERVER.boreDestroysBlocks.get() == false);
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    protected void stockTracks() {
        ItemStack stack = RollingStock.getOrThrow((AbstractMinecart)this).pullItem(this.trackContainer::canFit);
        if (!stack.isEmpty()) {
            this.trackContainer.insert(stack);
        }
    }

    protected boolean placeTrack(BlockPos targetPos, BlockState oldState, RailShape shape) {
        ServerPlayer owner = MinecartUtil.getFakePlayer((AbstractMinecart)this);
        if (oldState.is(RailcraftTags.Blocks.TUNNEL_BORE_REPLACEABLE_BLOCKS)) {
            LevelUtil.destroyBlock(this.level(), targetPos, (Player)owner, true);
        }
        if (oldState.isAir() && Block.canSupportRigidBlock((BlockGetter)this.level(), (BlockPos)targetPos.below())) {
            return this.trackContainer.stream().filter(SlotAccessor::hasItem).peek(slot -> {
                boolean placed = TrackUtil.placeRailAt(slot.item(), (ServerLevel)this.level(), targetPos, shape);
                if (placed) {
                    slot.extract();
                }
            }).findFirst().isPresent();
        }
        return false;
    }

    protected boolean checkForLava(BlockPos targetPos, RailShape dir) {
        int xStart = targetPos.getX() - 1;
        int zStart = targetPos.getZ() - 1;
        int xEnd = targetPos.getX() + 1;
        int zEnd = targetPos.getZ() + 1;
        if (dir == RailShape.NORTH_SOUTH) {
            --xStart;
            ++xEnd;
        } else {
            --zStart;
            ++zEnd;
        }
        int y = targetPos.getY();
        for (BlockPos blockPos : BlockPos.betweenClosed((int)xStart, (int)y, (int)zStart, (int)xEnd, (int)(y + 3), (int)zEnd)) {
            FluidState fluid = this.level().getFluidState(blockPos);
            if (!fluid.is(FluidTags.LAVA)) continue;
            return true;
        }
        return false;
    }

    private <T> T layerAction(BlockPos targetPos, RailShape trackShape, T initialValue, BiFunction<BlockPos, RailShape, T> action, BiFunction<T, T, T> sum) {
        int jj;
        T returnValue = initialValue;
        int x = targetPos.getX();
        int y = targetPos.getY();
        int z = targetPos.getZ();
        for (jj = y; jj < y + 3; ++jj) {
            returnValue = sum.apply(returnValue, action.apply(new BlockPos(x, jj, z), trackShape));
        }
        if (trackShape == RailShape.NORTH_SOUTH) {
            --x;
        } else {
            --z;
        }
        for (jj = y; jj < y + 3; ++jj) {
            returnValue = sum.apply(returnValue, action.apply(new BlockPos(x, jj, z), trackShape));
        }
        x = targetPos.getX();
        z = targetPos.getZ();
        if (trackShape == RailShape.NORTH_SOUTH) {
            ++x;
        } else {
            ++z;
        }
        for (jj = y; jj < y + 3; ++jj) {
            returnValue = sum.apply(returnValue, action.apply(new BlockPos(x, jj, z), trackShape));
        }
        return returnValue;
    }

    protected boolean boreLayer(BlockPos targetPos, RailShape dir) {
        return this.layerAction(targetPos, dir, true, this::mineBlock, (s, r) -> s != false && r != false);
    }

    protected boolean mineBlock(BlockPos targetPos, RailShape preferredShape) {
        RailShape targetShape;
        BlockState targetState = this.level().getBlockState(targetPos);
        if (targetState.isAir()) {
            return true;
        }
        if (BaseRailBlock.isRail((BlockState)targetState) ? preferredShape == (targetShape = TrackUtil.getTrackDirection((BlockGetter)this.level(), targetPos, targetState, (AbstractMinecart)this)) : targetState.is(Blocks.TORCH)) {
            return true;
        }
        ItemStack head = this.getItem(0);
        if (head.isEmpty()) {
            return false;
        }
        if (!this.canMineBlock(targetPos, targetState)) {
            return false;
        }
        ServerPlayer fakePlayer = MinecartUtil.getFakePlayerWith((AbstractMinecart)this, head);
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(this.level(), targetPos, targetState, (Player)fakePlayer);
        NeoForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return false;
        }
        if (!((Boolean)RailcraftConfig.SERVER.boreDestroysBlocks.get()).booleanValue() && this.level().getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            targetState.getDrops(new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.TOOL, (Object)head).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position())).forEach(stack -> {
                if (StackFilter.FUEL.test((ItemStack)stack)) {
                    stack = this.fuelContainer.insert((ItemStack)stack);
                }
                if (!stack.isEmpty() && ContainerTools.isItemStackBlock(stack, Blocks.GRAVEL)) {
                    stack = this.ballastContainer.insert((ItemStack)stack);
                }
                if (!stack.isEmpty()) {
                    stack = RollingStock.getOrThrow((AbstractMinecart)this).pushItem((ItemStack)stack);
                }
                if (!stack.isEmpty()) {
                    Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)stack);
                }
            });
        }
        LevelUtil.setAir(this.level(), targetPos);
        head.hurtAndBreak(1, fakePlayer.serverLevel(), fakePlayer, __ -> this.setItem(0, ItemStack.EMPTY));
        return true;
    }

    private boolean canMineBlock(BlockPos targetPos, BlockState existingState) {
        ItemStack head = this.getItem(0);
        if (existingState.getDestroySpeed((BlockGetter)this.level(), targetPos) < 0.0f) {
            return false;
        }
        return this.isMineableBlock(existingState) && this.canHeadHarvestBlock(head, existingState);
    }

    protected double getLayerHardness(BlockPos targetPos, RailShape dir) {
        mods.railcraft.datamaps.TunnelBoreHead tunnelBoreHead;
        double hardness = this.layerAction(targetPos, dir, Float.valueOf(0.0f), this::getBlockHardness, Float::sum).floatValue();
        hardness *= 8.0;
        ItemStack boreSlot = this.getItem(0);
        if (!boreSlot.isEmpty() && (tunnelBoreHead = (mods.railcraft.datamaps.TunnelBoreHead)boreSlot.getItemHolder().getData(RailcraftDataMaps.TUNNEL_BORE_HEAD)) != null) {
            double dig = tunnelBoreHead.digModifier();
            hardness /= dig;
            Holder.Reference efficiencyEnchantment = this.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.EFFICIENCY);
            int e = boreSlot.getEnchantmentLevel((Holder)efficiencyEnchantment);
            hardness /= (double)(e * e) * 0.2 + 1.0;
        }
        return hardness /= ((Double)RailcraftConfig.SERVER.boreMiningSpeedMultiplier.get()).doubleValue();
    }

    protected float getBlockHardness(BlockPos pos, RailShape dir) {
        RailShape trackMeta;
        BlockState blockState = this.level().getBlockState(pos);
        if (blockState.isAir()) {
            return 0.0f;
        }
        if (BaseRailBlock.isRail((BlockState)blockState) && dir == (trackMeta = TrackUtil.getTrackDirection((BlockGetter)this.level(), pos, blockState, (AbstractMinecart)this))) {
            return 0.0f;
        }
        if (blockState.is(Blocks.TORCH)) {
            return 0.0f;
        }
        if (blockState.is(Blocks.OBSIDIAN)) {
            return 15.0f;
        }
        if (!this.canMineBlock(pos, blockState)) {
            return 0.1f;
        }
        float hardness = blockState.getDestroySpeed((BlockGetter)this.level(), pos);
        if (hardness <= 0.0f) {
            hardness = 0.1f;
        }
        return hardness;
    }

    public boolean canCollideWith(Entity other) {
        return other instanceof LivingEntity;
    }

    public float getBoreRotationAngle() {
        return (float)Math.toRadians(this.boreRotationAngle);
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("facing", this.getFacing().get3DDataValue());
        tag.putInt("delay", this.getDelay());
        tag.putBoolean("active", this.isActive());
        tag.putInt("burnTime", this.getBurnTime());
        tag.putInt("fuel", this.fuel);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setFacing(Direction.from3DDataValue((int)tag.getInt("facing")));
        this.setDelay(tag.getInt("delay"));
        this.setActive(tag.getBoolean("active"));
        this.setBurnTime(tag.getInt("burnTime"));
        this.setFuel(tag.getInt("fuel"));
    }

    protected int getDelay() {
        return this.delay;
    }

    protected void setDelay(int i) {
        this.delay = i;
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean active) {
        Train.State state;
        this.active = active;
        Train.State state2 = state = active ? Train.State.STOPPED : Train.State.NORMAL;
        if (!this.level().isClientSide()) {
            RollingStock.getOrThrow((AbstractMinecart)this).train().setState(state);
        }
    }

    protected boolean isMoving() {
        return (Boolean)this.entityData.get(MOVING);
    }

    protected void setMoving(boolean moving) {
        this.entityData.set(MOVING, (Object)moving);
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int fuel) {
        this.fuel = fuel;
    }

    public boolean outOfFuel() {
        return this.getFuel() <= 12;
    }

    public boolean hasFuel() {
        return this.getFuel() > 0;
    }

    protected void stockFuel() {
        ItemStack stack = RollingStock.getOrThrow((AbstractMinecart)this).pullItem(this.fuelContainer::canFit);
        if (!stack.isEmpty()) {
            this.fuelContainer.insert(stack);
        }
    }

    protected void addFuel() {
        int burn = 0;
        for (int slot = 0; slot < this.fuelContainer.getContainerSize(); ++slot) {
            ItemStack stack = this.fuelContainer.getItem(slot);
            if (stack.isEmpty() || (burn = stack.getBurnTime(null)) <= 0) continue;
            if (stack.getItem().hasCraftingRemainingItem(stack)) {
                this.fuelContainer.setItem(slot, stack.getItem().getCraftingRemainingItem(stack));
                break;
            }
            this.fuelContainer.removeItem(slot, 1);
            break;
        }
        if (burn > 0) {
            this.setBurnTime(burn + this.getFuel());
            this.setFuel(this.getFuel() + burn);
        }
    }

    public int getBurnProgressScaled(int i) {
        int burn = this.getBurnTime();
        if (burn == 0) {
            return 0;
        }
        return this.getFuel() * i / burn;
    }

    protected void spendFuel() {
        this.setFuel(this.getFuel() - 12);
    }

    protected void forceUpdateBoreHead() {
        ItemStack boreStack = this.getItem(0);
        if (!boreStack.isEmpty()) {
            boreStack = boreStack.copy();
        }
        this.entityData.set(BORE_HEAD, (Object)boreStack);
    }

    @Nullable
    public TunnelBoreHead getBoreHead() {
        ItemStack boreStack = (ItemStack)this.entityData.get(BORE_HEAD);
        Item item = boreStack.getItem();
        if (item instanceof TunnelBoreHead) {
            TunnelBoreHead head = (TunnelBoreHead)item;
            return head;
        }
        return null;
    }

    protected void applyNaturalSlowdown() {
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.991999979019165, 0.0, 0.991999979019165));
    }

    @Override
    public boolean isPoweredCart() {
        return true;
    }

    public void setChanged() {
        if (!this.isActive()) {
            this.setDelay(5);
        }
    }

    public final Direction getFacing() {
        return (Direction)this.entityData.get(FACING);
    }

    protected final void setFacing(Direction facing) {
        this.entityData.set(FACING, (Object)facing);
        this.setYaw();
    }

    @Override
    public Optional<Side> disabledSide() {
        return Optional.of(Side.FRONT);
    }

    @Override
    public boolean isLinkableWith(RollingStock cart) {
        BlockPos pos = this.getPositionAhead(-3.1f);
        float dist = 2.5f;
        dist *= dist;
        return cart.entity().distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) < (double)dist;
    }

    @Override
    public float getLinkageDistance(RollingStock cart) {
        return 4.0f;
    }

    @Override
    public float getOptimalDistance(RollingStock cart) {
        return 3.1f;
    }

    @Override
    public void linked(RollingStock cart) {
    }

    @Override
    public void unlinked(RollingStock cart) {
    }

    @Override
    public boolean canBeAdjusted(RollingStock cart) {
        return !this.isActive();
    }

    public boolean shouldDoRailFunctions() {
        return false;
    }

    public PartEntity<?>[] getParts() {
        return this.parts;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.containers.stream().filter(m -> m.containsSlot(index)).allMatch(m -> m.filter().test(stack));
    }

    public boolean attackEntityFromPart(TunnelBorePart part, DamageSource damageSource, float damage) {
        return this.hurt(damageSource, damage);
    }

    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new TunnelBoreMenu(id, inventory, this);
    }
}

