/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import mods.railcraft.api.charge.Charge;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.RailcraftMinecart;
import mods.railcraft.world.inventory.EnergyMinecartMenu;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.component.LocomotiveEnergyComponent;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyMinecart
extends RailcraftMinecart {
    public static final int MAX_CHARGE = 50000;
    private static final EntityDataAccessor<Integer> ENERGY = SynchedEntityData.defineId(EnergyMinecart.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final CartStorage energyStorage = new CartStorage();

    public EnergyMinecart(EntityType<?> type, Level level) {
        super(type, level);
    }

    public EnergyMinecart(ItemStack itemStack, double x, double y, double z, Level level) {
        super(itemStack, (EntityType)RailcraftEntityTypes.ENERGY_MINECART.get(), x, y, z, level);
        this.loadFromItemStack(itemStack);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ENERGY, (Object)0);
    }

    protected void moveAlongTrack(BlockPos pos, BlockState state) {
        super.moveAlongTrack(pos, state);
        if (!this.level().isClientSide) {
            int drawnFromTrack = Charge.distribution.network((ServerLevel)this.level()).access(this.blockPosition()).removeCharge(this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored(), false);
            this.energyStorage.receiveEnergy(drawnFromTrack, false);
        }
    }

    public int getContainerSize() {
        return 0;
    }

    public IEnergyStorage getBatteryCart() {
        return this.energyStorage;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.energyStorage.setEnergyStored(tag.getInt("energy"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("energy", this.energyStorage.getEnergyStored());
    }

    @Override
    protected void loadFromItemStack(ItemStack itemStack) {
        super.loadFromItemStack(itemStack);
        if (itemStack.has(RailcraftDataComponents.LOCOMOTIVE_ENERGY)) {
            this.energyStorage.setEnergyStored(((LocomotiveEnergyComponent)itemStack.get(RailcraftDataComponents.LOCOMOTIVE_ENERGY)).energy());
        }
    }

    @Override
    public ItemStack getPickResult() {
        ItemStack itemStack = super.getPickResult();
        itemStack.set(RailcraftDataComponents.LOCOMOTIVE_ENERGY, (Object)new LocomotiveEnergyComponent(this.energyStorage.getEnergyStored()));
        return itemStack;
    }

    @Override
    public Item getDropItem() {
        return (Item)RailcraftItems.ENERGY_MINECART.get();
    }

    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new EnergyMinecartMenu(id, playerInventory, this);
    }

    private class CartStorage
    implements IEnergyStorage {
        private CartStorage() {
        }

        public int getEnergyStored() {
            return (Integer)EnergyMinecart.this.entityData.get(ENERGY);
        }

        public void setEnergyStored(int amount) {
            EnergyMinecart.this.entityData.set(ENERGY, (Object)amount);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive()) {
                return 0;
            }
            int energyStored = this.getEnergyStored();
            int energyReceived = Math.min(50000 - energyStored, maxReceive);
            if (!simulate) {
                this.setEnergyStored(energyStored + energyReceived);
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.canExtract()) {
                return 0;
            }
            int energyStored = this.getEnergyStored();
            int energyExtracted = Math.min(energyStored, maxExtract);
            if (!simulate) {
                this.setEnergyStored(energyStored - energyExtracted);
            }
            return energyExtracted;
        }

        public int getMaxEnergyStored() {
            return 50000;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

