/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.fluids;

import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.world.item.FluidBottleItem;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class CreosoteBottleWrapper
implements IFluidHandlerItem {
    @NotNull
    protected ItemStack container;

    public CreosoteBottleWrapper(@NotNull ItemStack container) {
        this.container = container;
    }

    @NotNull
    public ItemStack getContainer() {
        return this.container;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return fluid.is(RailcraftTags.Fluids.CREOSOTE);
    }

    @NotNull
    public FluidStack getFluid() {
        Item item = this.container.getItem();
        if (item instanceof FluidBottleItem) {
            FluidBottleItem bottle = (FluidBottleItem)item;
            return new FluidStack(bottle.getFluid(), 333);
        }
        return FluidStack.EMPTY;
    }

    protected void setFluid(@NotNull FluidStack fluidStack) {
        this.container = fluidStack.isEmpty() ? new ItemStack((ItemLike)Items.GLASS_BOTTLE) : new ItemStack((ItemLike)RailcraftItems.CREOSOTE_BOTTLE.get());
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return 333;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || resource.getAmount() < 333 || !this.getFluid().isEmpty() || !this.canFillFluidType(resource)) {
            return 0;
        }
        if (action.execute()) {
            this.setFluid(resource);
        }
        return 333;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || resource.getAmount() < 333) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)resource)) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || maxDrain < 333) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty()) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }
}

