/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.to_server;

import com.mojang.authlib.GameProfile;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.util.routing.RouterBlockEntity;
import mods.railcraft.world.level.block.entity.LockableSwitchTrackActuatorBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetRoutingDetectorMessage(BlockPos blockPos, RouterBlockEntity.Railway railway, LockableSwitchTrackActuatorBlockEntity.Lock lock) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetRoutingDetectorMessage> TYPE = new CustomPacketPayload.Type(RailcraftConstants.rl("set_routing_detector"));
    public static final StreamCodec<FriendlyByteBuf, SetRoutingDetectorMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SetRoutingDetectorMessage::blockPos, (StreamCodec)NeoForgeStreamCodecs.enumCodec(RouterBlockEntity.Railway.class), SetRoutingDetectorMessage::railway, (StreamCodec)NeoForgeStreamCodecs.enumCodec(LockableSwitchTrackActuatorBlockEntity.Lock.class), SetRoutingDetectorMessage::lock, SetRoutingDetectorMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SetRoutingDetectorMessage message, IPayloadContext context) {
        Player player = context.player();
        Level level = player.level();
        GameProfile senderProfile = player.getGameProfile();
        level.getBlockEntity(message.blockPos, (BlockEntityType)RailcraftBlockEntityTypes.ROUTING_DETECTOR.get()).filter(routingDetector -> routingDetector.canAccess(senderProfile)).ifPresent(routingDetector -> {
            routingDetector.setLock(message.lock.equals(LockableSwitchTrackActuatorBlockEntity.Lock.UNLOCKED) ? null : senderProfile);
            routingDetector.setRailway(message.railway.equals(RouterBlockEntity.Railway.PUBLIC) ? null : senderProfile);
            routingDetector.syncToClient();
            routingDetector.setChanged();
        });
    }
}

