/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.worldgen;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.data.worldgen.placements.RailcraftOrePlacements;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class RailcraftBiomeModifiers {
    private static final ResourceKey<BiomeModifier> LEAD_ORE = RailcraftBiomeModifiers.createKey("add_lead_ore");
    private static final ResourceKey<BiomeModifier> TIN_ORE_SMALL = RailcraftBiomeModifiers.createKey("add_tin_ore_small");
    private static final ResourceKey<BiomeModifier> TIN_ORE_LARGE = RailcraftBiomeModifiers.createKey("add_tin_ore_large");
    private static final ResourceKey<BiomeModifier> SULFUR_ORE_UPPER = RailcraftBiomeModifiers.createKey("add_sulfur_ore_upper");
    private static final ResourceKey<BiomeModifier> SULFUR_ORE_LOWER = RailcraftBiomeModifiers.createKey("add_sulfur_ore_lower");
    private static final ResourceKey<BiomeModifier> ZINC_ORE = RailcraftBiomeModifiers.createKey("add_zinc_ore");
    private static final ResourceKey<BiomeModifier> NICKEL_ORE_UPPER = RailcraftBiomeModifiers.createKey("add_nickel_ore_upper");
    private static final ResourceKey<BiomeModifier> NICKEL_ORE_MIDDLE = RailcraftBiomeModifiers.createKey("add_nickel_ore_middle");
    private static final ResourceKey<BiomeModifier> NICKEL_ORE_SMALL = RailcraftBiomeModifiers.createKey("add_nickel_ore_small");
    private static final ResourceKey<BiomeModifier> SILVER_ORE = RailcraftBiomeModifiers.createKey("add_silver_ore");
    private static final ResourceKey<BiomeModifier> SILVER_ORE_LOWER = RailcraftBiomeModifiers.createKey("add_silver_ore_lower");
    private static final ResourceKey<BiomeModifier> QUARRIED_STONE = RailcraftBiomeModifiers.createKey("add_quarried_stone");
    private static final ResourceKey<BiomeModifier> SALTPETER = RailcraftBiomeModifiers.createKey("add_saltpeter");
    private static final ResourceKey<BiomeModifier> FIRESTONE = RailcraftBiomeModifiers.createKey("add_firestone");

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderSet.Named overworldTag = context.lookup(Registries.BIOME).getOrThrow(BiomeTags.IS_OVERWORLD);
        HolderSet.Named netherTag = context.lookup(Registries.BIOME).getOrThrow(BiomeTags.IS_NETHER);
        HolderSet.Named forestTag = context.lookup(Registries.BIOME).getOrThrow(BiomeTags.IS_FOREST);
        context.register(LEAD_ORE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, RailcraftBiomeModifiers.getPlacedFeature(context, RailcraftOrePlacements.LEAD_ORE), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(TIN_ORE_SMALL, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, RailcraftBiomeModifiers.getPlacedFeature(context, RailcraftOrePlacements.TIN_ORE_SMALL), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(TIN_ORE_LARGE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, RailcraftBiomeModifiers.getPlacedFeature(context, RailcraftOrePlacements.TIN_ORE_LARGE), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(SULFUR_ORE_UPPER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, RailcraftBiomeModifiers.getPlacedFeature(context, RailcraftOrePlacements.SULFUR_ORE_UPPER), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(SULFUR_ORE_LOWER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, RailcraftBiomeModifiers.getPlacedFeature(context, RailcraftOrePlacements.SULFUR_ORE_LOWER), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(ZINC_ORE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, RailcraftBiomeModifiers.getPlacedFeature(context, RailcraftOrePlacements.ZINC_ORE), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(NICKEL_ORE_UPPER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, RailcraftBiomeModifiers.getPlacedFeature(context, RailcraftOrePlacements.NICKEL_ORE_UPPER), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(NICKEL_ORE_MIDDLE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, RailcraftBiomeModifiers.getPlacedFeature(context, RailcraftOrePlacements.NICKEL_ORE_MIDDLE), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(NICKEL_ORE_SMALL, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, RailcraftBiomeModifiers.getPlacedFeature(context, RailcraftOrePlacements.NICKEL_ORE_SMALL), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(SILVER_ORE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, RailcraftBiomeModifiers.getPlacedFeature(context, RailcraftOrePlacements.SILVER_ORE), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(SILVER_ORE_LOWER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, RailcraftBiomeModifiers.getPlacedFeature(context, RailcraftOrePlacements.SILVER_ORE_LOWER), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(QUARRIED_STONE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)forestTag, RailcraftBiomeModifiers.getPlacedFeature(context, RailcraftOrePlacements.QUARRIED_STONE), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(SALTPETER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, RailcraftBiomeModifiers.getPlacedFeature(context, RailcraftOrePlacements.SALTPETER), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(FIRESTONE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)netherTag, RailcraftBiomeModifiers.getPlacedFeature(context, RailcraftOrePlacements.FIRESTONE), GenerationStep.Decoration.UNDERGROUND_ORES));
    }

    private static HolderSet<PlacedFeature> getPlacedFeature(BootstrapContext<BiomeModifier> context, ResourceKey<PlacedFeature> resourceKey) {
        return HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(resourceKey)});
    }

    private static ResourceKey<BiomeModifier> createKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)RailcraftConstants.rl(name));
    }
}

