/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.providers;

import java.util.concurrent.CompletableFuture;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.data.recipes.builders.BlastFurnaceRecipeBuilder;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class BlastFurnaceRecipeProvider
extends RecipeProvider {
    private BlastFurnaceRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider) {
        super(packOutput, provider);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
    }

    public static void genRecipes(RecipeOutput recipeOutput) {
        BlastFurnaceRecipeBuilder.smelting((ItemLike)RailcraftBlocks.STEEL_BLOCK.get(), 1, Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_IRON), 9, 9).unlockedBy("has_iron_block", BlastFurnaceRecipeProvider.has((TagKey)Tags.Items.STORAGE_BLOCKS_IRON)).save(recipeOutput, BlastFurnaceRecipeProvider.getRailcraftBlastingRecipeName((ItemLike)RailcraftItems.STEEL_BLOCK.get()));
        BlastFurnaceRecipeBuilder.smelting((ItemLike)RailcraftItems.STEEL_INGOT.get(), Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), 1, 1).unlockedBy("has_iron_ingots", BlastFurnaceRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(recipeOutput, BlastFurnaceRecipeProvider.getRailcraftBlastingRecipeName((ItemLike)Items.IRON_INGOT));
        BlastFurnaceRecipeProvider.consumeIronSteelItems(recipeOutput);
    }

    private static void consumeIronSteelItems(RecipeOutput recipeOutput) {
        BlastFurnaceRecipeProvider.blastFurnaceSmelting(recipeOutput, (ItemLike)Items.BUCKET, 3);
        BlastFurnaceRecipeProvider.blastFurnaceSmelting(recipeOutput, (ItemLike)Items.IRON_HELMET, 5);
        BlastFurnaceRecipeProvider.blastFurnaceSmelting(recipeOutput, (ItemLike)Items.IRON_CHESTPLATE, 8);
        BlastFurnaceRecipeProvider.blastFurnaceSmelting(recipeOutput, (ItemLike)Items.IRON_LEGGINGS, 7);
        BlastFurnaceRecipeProvider.blastFurnaceSmelting(recipeOutput, (ItemLike)Items.IRON_BOOTS, 4);
        BlastFurnaceRecipeProvider.blastFurnaceSmelting(recipeOutput, (ItemLike)Items.IRON_HORSE_ARMOR, 4);
        BlastFurnaceRecipeProvider.blastFurnaceSmelting(recipeOutput, (ItemLike)Items.IRON_SWORD, 2);
        BlastFurnaceRecipeProvider.blastFurnaceSmelting(recipeOutput, (ItemLike)Items.IRON_SHOVEL, 1);
        BlastFurnaceRecipeProvider.blastFurnaceSmelting(recipeOutput, (ItemLike)Items.IRON_PICKAXE, 3);
        BlastFurnaceRecipeProvider.blastFurnaceSmelting(recipeOutput, (ItemLike)Items.IRON_AXE, 3);
        BlastFurnaceRecipeProvider.blastFurnaceSmelting(recipeOutput, (ItemLike)Items.IRON_HOE, 2);
        BlastFurnaceRecipeProvider.blastFurnaceSmelting(recipeOutput, (ItemLike)Items.SHEARS, 2);
        BlastFurnaceRecipeProvider.blastFurnaceSmelting(recipeOutput, (ItemLike)Items.IRON_DOOR, 2);
        BlastFurnaceRecipeProvider.blastFurnaceSmelting(recipeOutput, (ItemLike)Items.IRON_TRAPDOOR, 4);
        BlastFurnaceRecipeProvider.blastFurnaceRecycling(recipeOutput, (ItemLike)RailcraftItems.STEEL_HELMET.get(), 4);
        BlastFurnaceRecipeProvider.blastFurnaceRecycling(recipeOutput, (ItemLike)RailcraftItems.STEEL_CHESTPLATE.get(), 7);
        BlastFurnaceRecipeProvider.blastFurnaceRecycling(recipeOutput, (ItemLike)RailcraftItems.STEEL_LEGGINGS.get(), 6);
        BlastFurnaceRecipeProvider.blastFurnaceRecycling(recipeOutput, (ItemLike)RailcraftItems.STEEL_BOOTS.get(), 3);
        BlastFurnaceRecipeProvider.blastFurnaceRecycling(recipeOutput, (ItemLike)RailcraftItems.STEEL_SWORD.get(), 1);
        BlastFurnaceRecipeProvider.blastFurnaceRecycling(recipeOutput, (ItemLike)RailcraftItems.STEEL_PICKAXE.get(), 2);
        BlastFurnaceRecipeProvider.blastFurnaceRecycling(recipeOutput, (ItemLike)RailcraftItems.STEEL_HOE.get(), 1);
        BlastFurnaceRecipeProvider.blastFurnaceRecycling(recipeOutput, (ItemLike)RailcraftItems.STEEL_AXE.get(), 2);
        BlastFurnaceRecipeProvider.blastFurnaceRecycling(recipeOutput, (ItemLike)RailcraftItems.STEEL_SHEARS.get(), 1);
        BlastFurnaceRecipeProvider.blastFurnaceRecycling(recipeOutput, (ItemLike)RailcraftItems.IRON_CROWBAR.get(), 2);
    }

    private static void blastFurnaceSmelting(RecipeOutput recipeOutput, ItemLike item, int multiplier) {
        BlastFurnaceRecipeBuilder.smelting((ItemLike)RailcraftItems.STEEL_INGOT.get(), Ingredient.of((ItemLike[])new ItemLike[]{item}), multiplier, multiplier).unlockedBy(BlastFurnaceRecipeProvider.getHasName((ItemLike)item), BlastFurnaceRecipeProvider.has((ItemLike)item)).save(recipeOutput, BlastFurnaceRecipeProvider.getRailcraftBlastingRecipeName(item));
    }

    private static void blastFurnaceRecycling(RecipeOutput recipeOutput, ItemLike item, int multiplier) {
        BlastFurnaceRecipeBuilder.recycling((ItemLike)RailcraftItems.STEEL_INGOT.get(), Ingredient.of((ItemLike[])new ItemLike[]{item}), multiplier).unlockedBy(BlastFurnaceRecipeProvider.getHasName((ItemLike)item), BlastFurnaceRecipeProvider.has((ItemLike)item)).save(recipeOutput, BlastFurnaceRecipeProvider.getRailcraftBlastingRecipeName(item));
    }

    private static ResourceLocation getRailcraftBlastingRecipeName(ItemLike item) {
        String tag = BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath();
        return RailcraftConstants.rl("blasting_" + tag);
    }
}

