/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.model;

import mods.railcraft.world.entity.vehicle.TunnelBore;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;

public class TunnelBoreModel
extends HierarchicalModel<TunnelBore> {
    private final ModelPart root;
    private final ModelPart boreHead;
    private final ModelPart furnaceActive;
    private final ModelPart furnaceIdle;

    public TunnelBoreModel(ModelPart root) {
        super(RenderType::entityTranslucentCull);
        this.root = root;
        this.boreHead = root.getChild("boreHead");
        this.furnaceActive = root.getChild("furnaceActive");
        this.furnaceIdle = root.getChild("furnaceIdle");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 0).addBox(-40.0f, 3.0f, -8.0f, 80.0f, 2.0f, 16.0f), PartPose.ZERO);
        root.addOrReplaceChild("rear", CubeListBuilder.create().texOffs(0, 18).addBox(6.0f, -21.0f, -12.0f, 42.0f, 24.0f, 24.0f), PartPose.ZERO);
        root.addOrReplaceChild("furnaceBox", CubeListBuilder.create().texOffs(99, 112).addBox(-18.0f, -29.0f, -16.0f, 24.0f, 32.0f, 32.0f), PartPose.ZERO);
        root.addOrReplaceChild("boreHead", CubeListBuilder.create().texOffs(59, 78).addBox(-52.0f, -16.0f, -16.0f, 2.0f, 32.0f, 32.0f), PartPose.offset((float)0.0f, (float)-18.0f, (float)0.0f));
        root.addOrReplaceChild("boreFrame", CubeListBuilder.create().texOffs(96, 18).addBox(-50.0f, -40.0f, -24.0f, 32.0f, 43.0f, 48.0f), PartPose.ZERO);
        root.addOrReplaceChild("furnaceIdle", CubeListBuilder.create().texOffs(0, 66).addBox(-14.0f, -19.0f, 16.0f, 16.0f, 16.0f, 2.0f).addBox(-14.0f, -19.0f, -18.0f, 16.0f, 16.0f, 2.0f), PartPose.ZERO);
        root.addOrReplaceChild("furnaceActive", CubeListBuilder.create().texOffs(37, 66).addBox(-14.0f, -19.0f, 16.0f, 16.0f, 16.0f, 2.0f).addBox(-14.0f, -19.0f, -18.0f, 16.0f, 16.0f, 2.0f), PartPose.ZERO);
        root.addOrReplaceChild("stack", CubeListBuilder.create().texOffs(74, 66).addBox(-8.0f, -35.0f, 13.0f, 4.0f, 16.0f, 4.0f).addBox(-8.0f, -35.0f, -17.0f, 4.0f, 16.0f, 4.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)255, (int)255);
    }

    public void setBoreHeadRotation(float rotation) {
        this.boreHead.xRot = rotation;
    }

    public void setBoreActive(boolean active) {
        this.furnaceActive.visible = active;
        this.furnaceIdle.visible = !active;
    }

    public void setRenderBoreHead(boolean visible) {
        this.boreHead.visible = visible;
    }

    public void setupAnim(TunnelBore entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public ModelPart root() {
        return this.root;
    }
}

