/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.client.gui.screen.IngameWindowScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.MultiButton;
import mods.railcraft.client.gui.widget.button.ToggleButton;
import mods.railcraft.network.to_server.SetActionSignalBoxMessage;
import mods.railcraft.world.level.block.entity.signal.ActionSignalBoxBlockEntity;
import mods.railcraft.world.level.block.entity.signal.LockableSignalBoxBlockEntity;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class ActionSignalBoxScreen
extends IngameWindowScreen {
    private static final int REFRESH_INTERVAL_TICKS = 20;
    private final ActionSignalBoxBlockEntity signalBox;
    private final Map<SignalAspect, ToggleButton> signalAspectButtons = new EnumMap<SignalAspect, ToggleButton>(SignalAspect.class);
    private MultiButton<LockableSignalBoxBlockEntity.Lock> lockButton;
    private int refreshTimer;

    public ActionSignalBoxScreen(ActionSignalBoxBlockEntity signalBox) {
        super(signalBox.getDisplayName());
        this.signalBox = signalBox;
    }

    public void init() {
        int centreX = (this.width - this.windowWidth) / 2;
        int centreY = (this.height - this.windowHeight) / 2;
        this.addSignalAspectButton(SignalAspect.GREEN, centreX + 7, centreY + 30, 50);
        this.addSignalAspectButton(SignalAspect.YELLOW, centreX + 63, centreY + 30, 50);
        this.addSignalAspectButton(SignalAspect.RED, centreX + 119, centreY + 30, 50);
        this.addSignalAspectButton(SignalAspect.BLINK_YELLOW, centreX + 12, centreY + 55, 70);
        this.addSignalAspectButton(SignalAspect.BLINK_RED, centreX + 94, centreY + 55, 70);
        this.lockButton = (MultiButton)this.addRenderableWidget((GuiEventListener)((MultiButton)((MultiButton.Builder)MultiButton.builder(ButtonTexture.SMALL_BUTTON, this.signalBox.getLock()).bounds(centreX + 152, centreY + 8, 16, 16)).tooltipFactory(this::updateLockButtonTooltip).stateCallback(this::setLock).build()));
        this.updateButtons();
    }

    private void addSignalAspectButton(SignalAspect signalAspect, int x, int y, int width) {
        EnumSet<SignalAspect> actionSignalAspects = this.signalBox.getActionSignalAspects();
        ToggleButton button = (ToggleButton)this.addRenderableWidget((GuiEventListener)((ToggleButton)((ToggleButton.Builder)ToggleButton.toggleBuilder((Component)signalAspect.getDisplayName(), btn -> ((ToggleButton)btn).setToggled(this.toggleSignalAspect(signalAspect)), ButtonTexture.LARGE_BUTTON).bounds(x, y, width, 20)).toggled(actionSignalAspects.contains((Object)signalAspect)).build()));
        this.signalAspectButtons.put(signalAspect, button);
    }

    private void setLock(LockableSignalBoxBlockEntity.Lock lock) {
        if (this.signalBox.getLock() != lock) {
            this.signalBox.setLock(lock);
            this.signalBox.setOwner(lock == LockableSignalBoxBlockEntity.Lock.UNLOCKED ? null : this.minecraft.player.getGameProfile());
            this.sendAttributes();
        }
    }

    private Optional<Tooltip> updateLockButtonTooltip(LockableSignalBoxBlockEntity.Lock lock) {
        return Optional.of(Tooltip.create((Component)(switch (lock) {
            default -> throw new MatchException(null, null);
            case LockableSignalBoxBlockEntity.Lock.LOCKED -> Component.translatable((String)Translations.Screen.ACTION_SIGNAL_BOX_LOCKED, (Object[])new Object[]{this.signalBox.getOwnerOrThrow().getName()});
            case LockableSignalBoxBlockEntity.Lock.UNLOCKED -> Component.translatable((String)Translations.Screen.ACTION_SIGNAL_BOX_UNLOCKED);
        })));
    }

    private boolean toggleSignalAspect(SignalAspect signalAspect) {
        boolean toggled = false;
        if (!this.signalBox.getActionSignalAspects().remove((Object)signalAspect)) {
            this.signalBox.getActionSignalAspects().add(signalAspect);
            toggled = true;
        }
        this.sendAttributes();
        return toggled;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.refreshTimer++ >= 20) {
            this.refreshTimer = 0;
            this.updateButtons();
        }
    }

    private void updateButtons() {
        boolean canAccess;
        this.lockButton.active = canAccess = this.signalBox.canAccess(this.minecraft.player.getGameProfile());
        this.lockButton.setState(this.signalBox.getLock());
        this.signalAspectButtons.forEach((signalAspect, button) -> {
            button.active = canAccess;
            button.setToggled(this.signalBox.getActionSignalAspects().contains(signalAspect));
        });
    }

    private void sendAttributes() {
        if (!this.signalBox.canAccess(this.minecraft.player.getGameProfile())) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new SetActionSignalBoxMessage(this.signalBox.getBlockPos(), this.signalBox.getActionSignalAspects(), this.lockButton.getState()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

