/*
 * Decompiled with CFR 0.152.
 */
package dev.zeddevstuff.keybindspurger.mixin;

import dev.zeddevstuff.keybindspurger.Keybindspurger;
import dev.zeddevstuff.keybindspurger.ModListGetter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinManager
implements IMixinConfigPlugin {
    private List<String> mixins = new ArrayList<String>();
    private boolean controllingDetected = false;
    private static boolean neoForgeDetected = false;

    public static boolean isNeoForge() {
        return neoForgeDetected;
    }

    public void onLoad(String s) {
        List<String> mods = ModListGetter.getModList();
        neoForgeDetected = mods.contains("neoforge");
        this.controllingDetected = mods.contains("controlling");
        Keybindspurger.LOGGER.info("Controlling detected: " + this.controllingDetected);
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        boolean apply = true;
        if (this.controllingDetected) {
            apply = mixinClassName.toLowerCase().startsWith("dev.zeddevstuff.keybindspurger.mixin.cc") || mixinClassName.toLowerCase().startsWith("dev.zeddevstuff.keybindspurger.mixin.icc");
        } else {
            boolean bl = apply = !mixinClassName.toLowerCase().startsWith("dev.zeddevstuff.keybindspurger.mixin.cc") || !mixinClassName.toLowerCase().startsWith("dev.zeddevstuff.keybindspurger.mixin.icc");
        }
        if (mixinClassName.equals("dev.zeddevstuff.keybindspurger.mixin.IKeyBindsListAccessor") || mixinClassName.equals("dev.zeddevstuff.keybindspurger.mixin.IScreenAccessor") || mixinClassName.equals("dev.zeddevstuff.keybindspurger.mixin.IOptionsSubScreenAccessor")) {
            apply = true;
        }
        if (apply) {
            Keybindspurger.LOGGER.info("Applying mixin: " + mixinClassName);
        }
        return apply;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return List.of();
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

