/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.mixin;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import de.mrjulsen.crn.CRNPlatformSpecific;
import de.mrjulsen.crn.data.train.DepartureHistory;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={StationBlockEntity.class})
public class StationBlockEntityMixin
implements IHaveGoggleInformation {
    private static final int MAX_ENTRIES = 5;
    private DepartureHistory.Stats stats;

    private StationBlockEntity self() {
        return (StationBlockEntity)this;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        int i;
        Map<String, Long> data;
        if (CRNPlatformSpecific.getStationFromBlockEntity((BlockEntity)this.self()) == null) {
            return false;
        }
        if (Minecraft.getInstance().level.getGameTime() % 100L == 0L) {
            DataAccessor.getFromServer((Object)CRNPlatformSpecific.getStationFromBlockEntity((BlockEntity)this.self()).name, ModAccessorTypes.GET_STATION_DEPARTURE_HISTORY, x -> {
                this.stats = x;
            });
        }
        CreateLang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.title")).forGoggles(tooltip);
        if (this.stats == null || this.stats.isEmpty()) {
            CreateLang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.nothing").withStyle(ChatFormatting.RED)).forGoggles(tooltip);
            return false;
        }
        CreateLang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.any").withStyle(ChatFormatting.GRAY)).forGoggles(tooltip);
        CreateLang.builder((String)"createrailwaysnavigator").add(this.formatTime(Minecraft.getInstance().level.getGameTime() - this.stats.getLastDeparture())).forGoggles(tooltip, 1);
        if (!this.stats.getDeparturesByCategory().isEmpty()) {
            CreateLang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.category").withStyle(ChatFormatting.GRAY)).forGoggles(tooltip);
            data = this.stats.getDeparturesByCategory();
            i = 0;
            for (Map.Entry<String, Long> d : data.entrySet()) {
                CreateLang.builder((String)"createrailwaysnavigator").add(TextUtils.empty().append((Component)TextUtils.text((String)(d.getKey() + ": ")).withStyle(ChatFormatting.DARK_AQUA)).append((Component)this.formatTime(Minecraft.getInstance().level.getGameTime() - d.getValue()))).forGoggles(tooltip, 1);
                if (++i < 5) continue;
                break;
            }
            if (data.size() > 5) {
                CreateLang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.has_more", (Object[])new Object[]{data.size() - 5}).withStyle(ChatFormatting.GRAY)).forGoggles(tooltip);
            }
        }
        if (!this.stats.getDeparturesByLine().isEmpty()) {
            CreateLang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.line").withStyle(ChatFormatting.GRAY)).forGoggles(tooltip);
            data = this.stats.getDeparturesByLine();
            i = 0;
            for (Map.Entry<String, Long> d : data.entrySet()) {
                CreateLang.builder((String)"createrailwaysnavigator").add(TextUtils.empty().append((Component)TextUtils.text((String)(d.getKey() + ": ")).withStyle(ChatFormatting.DARK_AQUA)).append((Component)this.formatTime(Minecraft.getInstance().level.getGameTime() - d.getValue()))).forGoggles(tooltip, 1);
                if (++i < 5) continue;
                break;
            }
            if (data.size() > 5) {
                CreateLang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.has_more", (Object[])new Object[]{data.size() - 5}).withStyle(ChatFormatting.GRAY)).forGoggles(tooltip);
            }
        }
        if (!this.stats.getDeparturesByName().isEmpty()) {
            CreateLang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.name").withStyle(ChatFormatting.GRAY)).forGoggles(tooltip);
            data = this.stats.getDeparturesByName();
            i = 0;
            for (Map.Entry<String, Long> d : data.entrySet()) {
                CreateLang.builder((String)"createrailwaysnavigator").add(TextUtils.empty().append((Component)TextUtils.text((String)(d.getKey() + ": ")).withStyle(ChatFormatting.DARK_AQUA)).append((Component)this.formatTime(Minecraft.getInstance().level.getGameTime() - d.getValue()))).forGoggles(tooltip, 1);
                if (++i < 5) continue;
                break;
            }
            if (data.size() > 5) {
                CreateLang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.has_more", (Object[])new Object[]{data.size() - 5}).withStyle(ChatFormatting.GRAY)).forGoggles(tooltip);
            }
        }
        CreateLang.builder((String)"createrailwaysnavigator").add(TextUtils.text((String)" ")).forGoggles(tooltip);
        CreateLang.builder((String)"createrailwaysnavigator").add(TextUtils.translate((String)"goggles.createrailwaysnavigator.train_listener.departures.press_shift_for_in_game_time").withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC)).forGoggles(tooltip);
        return true;
    }

    private MutableComponent formatTime(long ticks) {
        return TextUtils.text((String)(Minecraft.getInstance().player.isShiftKeyDown() ? TimeUtils.parseDurationShort((long)ticks) : TimeUtils.formatDurationMs((long)TimeUnit.SECONDS.toMillis((long)((double)ticks / DragonLib.mcTps()))))).withStyle(ChatFormatting.AQUA);
    }
}

