/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.TrainLine;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public record TrainInfo(TrainLine line, TrainCategory category) {
    private static final String NBT_TRAIN_CATEGORY = "Category";
    private static final String NBT_TRAIN_LINE = "Line";

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        if (this.category != null) {
            nbt.put(NBT_TRAIN_CATEGORY, (Tag)this.category.toNbt());
        }
        if (this.line != null) {
            nbt.put(NBT_TRAIN_LINE, (Tag)this.line.toNbt());
        }
        return nbt;
    }

    public static TrainInfo fromNbt(CompoundTag nbt) {
        return new TrainInfo(nbt.contains(NBT_TRAIN_LINE) ? TrainLine.fromNbt(nbt.getCompound(NBT_TRAIN_LINE)) : null, nbt.contains(NBT_TRAIN_CATEGORY) ? TrainCategory.fromNbt(nbt.getCompound(NBT_TRAIN_CATEGORY)) : null);
    }

    public static TrainInfo empty() {
        return new TrainInfo(null, null);
    }
}

