/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.herbsandharvest.block.crop.grapes;

import com.mamailes.herbsandharvest.init.MHHItems;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface GrapeVines {
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final BooleanProperty BERRIES = BlockStateProperties.BERRIES;

    public static InteractionResult use(@Nullable Entity pEntity, BlockState pState, Level pLevel, BlockPos pPos) {
        if (((Boolean)pState.getValue((Property)BERRIES)).booleanValue()) {
            Block.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)MHHItems.GRAPES.get(), 1));
            float f = Mth.randomBetween((RandomSource)pLevel.random, (float)0.8f, (float)1.2f);
            pLevel.playSound(null, pPos, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, f);
            BlockState blockstate = (BlockState)pState.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false));
            pLevel.setBlock(pPos, blockstate, 2);
            pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((Entity)pEntity, (BlockState)blockstate));
            return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static boolean hasGlowBerries(BlockState pState) {
        return pState.hasProperty((Property)BERRIES) && (Boolean)pState.getValue((Property)BERRIES) != false;
    }

    public static ToIntFunction<BlockState> emission(int pBerries) {
        return p_181216_ -> (Boolean)p_181216_.getValue((Property)BlockStateProperties.BERRIES) != false ? pBerries : 0;
    }
}

