/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.operations;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.config.ServerConfiguration;
import com.ldtteam.structurize.network.messages.UpdateClientRender;
import com.ldtteam.structurize.operations.BaseOperation;
import com.ldtteam.structurize.util.ChangeStorage;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;

public abstract class AreaOperation
extends BaseOperation {
    protected final Player player;
    protected final BlockPos startPos;
    protected final BlockPos endPos;
    private BlockPos currentPos;

    protected AreaOperation(Component storageText, Player player, BlockPos startPos, BlockPos endPos) {
        super(new ChangeStorage(storageText, player != null ? player.getUUID() : UUID.randomUUID()));
        this.player = player;
        this.startPos = new BlockPos(Math.min(startPos.getX(), endPos.getX()), Math.min(startPos.getY(), endPos.getY()), Math.min(startPos.getZ(), endPos.getZ()));
        this.endPos = new BlockPos(Math.max(startPos.getX(), endPos.getX()), Math.max(startPos.getY(), endPos.getY()), Math.max(startPos.getZ(), endPos.getZ()));
        this.currentPos = this.startPos;
    }

    @Override
    public final boolean apply(ServerLevel world) {
        if (this.player != null && this.player.level().dimension() != world.dimension()) {
            return false;
        }
        int count = 0;
        for (int y = this.currentPos.getY(); y <= this.endPos.getY(); ++y) {
            for (int x = this.currentPos.getX(); x <= this.endPos.getX(); ++x) {
                for (int z = this.currentPos.getZ(); z <= this.endPos.getZ(); ++z) {
                    BlockPos here = new BlockPos(x, y, z);
                    this.apply(world, here);
                    if (++count < (Integer)((ServerConfiguration)Structurize.getConfig().getServer()).maxOperationsPerTick.get()) continue;
                    this.currentPos = here;
                    return false;
                }
                this.currentPos = new BlockPos(x, y, this.startPos.getZ());
            }
            this.currentPos = new BlockPos(this.startPos.getX(), y, this.startPos.getZ());
        }
        new UpdateClientRender(this.startPos, this.endPos).sendToAllClients();
        return true;
    }

    protected abstract void apply(ServerLevel var1, BlockPos var2);
}

