/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structurize.api.ItemStackUtils;
import com.ldtteam.structurize.client.gui.WindowShapeTool;
import com.ldtteam.structurize.items.AbstractItemStructurize;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class ItemShapeTool
extends AbstractItemStructurize {
    public ItemShapeTool() {
        super("shapetool", new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().isClientSide) {
            new WindowShapeTool(context.getClickedPos().relative(context.getClickedFace()), (HolderLookup.Provider)context.getLevel().registryAccess()).open();
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.getItemInHand(hand);
        if (worldIn.isClientSide) {
            new WindowShapeTool(null, (HolderLookup.Provider)worldIn.registryAccess()).open();
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        if (ItemStackUtils.isEmpty(itemStack)) {
            return ItemStack.EMPTY;
        }
        return itemStack.copy();
    }

    public boolean hasCraftingRemainingItem(ItemStack itemStack) {
        return !ItemStackUtils.isEmpty(itemStack);
    }
}

