/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structurize.api.Utils;
import com.ldtteam.structurize.component.ModDataComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractItemWithPosSelector
extends Item {
    private static final String START_POS_TKEY = "item.possetter.firstpos";
    private static final String END_POS_TKEY = "item.possetter.secondpos";
    private static final String MISSING_POS_TKEY = "item.possetter.missingpos";

    public AbstractItemWithPosSelector(Item.Properties properties) {
        super(properties.component(ModDataComponents.POS_SELECTION, (Object)PosSelection.EMPTY));
    }

    public abstract InteractionResult onAirRightClick(BlockPos var1, BlockPos var2, Level var3, Player var4, ItemStack var5);

    public abstract AbstractItemWithPosSelector getRegisteredItemInstance();

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        PosSelection compound = PosSelection.readFromItemStack(itemstack);
        if (compound.startPos().isEmpty()) {
            if (worldIn.isClientSide()) {
                playerIn.displayClientMessage((Component)Component.translatable((String)"item.possetter.missingpos1"), false);
            }
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (compound.endPos().isEmpty()) {
            if (worldIn.isClientSide()) {
                playerIn.displayClientMessage((Component)Component.translatable((String)"item.possetter.missingpos2"), false);
            }
            return InteractionResultHolder.fail((Object)itemstack);
        }
        return new InteractionResultHolder(this.onAirRightClick(compound.startPos().get(), compound.endPos().get(), worldIn, playerIn, itemstack), (Object)itemstack);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        if (context.getLevel().isClientSide()) {
            context.getPlayer().displayClientMessage((Component)Component.translatable((String)END_POS_TKEY, (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}), false);
            Utils.playSuccessSound(context.getPlayer());
        }
        PosSelection.updateItemStack(context.getItemInHand(), data -> data.setEndpos(pos));
        return InteractionResult.SUCCESS;
    }

    public boolean canAttackBlock(BlockState state, Level worldIn, BlockPos pos, Player player) {
        ItemStack itemstack = player.getMainHandItem();
        if (!itemstack.getItem().equals((Object)this.getRegisteredItemInstance())) {
            itemstack = player.getOffhandItem();
        }
        PosSelection.updateItemStack(itemstack, data -> data.setStartPos(pos));
        if (player.getCommandSenderWorld().isClientSide()) {
            Utils.playSuccessSound(player);
            player.displayClientMessage((Component)Component.translatable((String)START_POS_TKEY, (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}), false);
        }
        return false;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return Float.MAX_VALUE;
    }

    @Deprecated(forRemoval=true, since="1.21")
    public static void setBounds(@NotNull ItemStack tool, @NotNull BlockPos start, @NotNull BlockPos end) {
        PosSelection.updateItemStack(tool, data -> data.setSelection(start, end));
    }

    @Deprecated(forRemoval=true, since="1.21")
    public static Tuple<BlockPos, BlockPos> getBounds(@NotNull ItemStack tool) {
        PosSelection tag = PosSelection.readFromItemStack(tool);
        return new Tuple((Object)tag.startPos().orElse(null), (Object)tag.endPos().orElse(null));
    }

    public record PosSelection(Optional<BlockPos> startPos, Optional<BlockPos> endPos) {
        public static final PosSelection EMPTY = new PosSelection(Optional.empty(), Optional.empty());
        public static final Codec<PosSelection> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPos.CODEC.optionalFieldOf("start_pos").forGetter(PosSelection::startPos), (App)BlockPos.CODEC.optionalFieldOf("end_pos").forGetter(PosSelection::endPos)).apply((Applicative)builder, PosSelection::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PosSelection> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), PosSelection::startPos, (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), PosSelection::endPos, PosSelection::new);

        public boolean hasSelection() {
            return this.startPos.isPresent() && this.endPos.isPresent();
        }

        public PosSelection setStartPos(BlockPos pos) {
            return new PosSelection(Optional.ofNullable(pos), this.endPos);
        }

        public PosSelection setEndpos(BlockPos pos) {
            return new PosSelection(this.startPos, Optional.ofNullable(pos));
        }

        public PosSelection setSelection(BlockPos startPos, BlockPos endPos) {
            return new PosSelection(Optional.ofNullable(startPos), Optional.ofNullable(endPos));
        }

        public void writeToItemStack(ItemStack itemStack) {
            itemStack.set(ModDataComponents.POS_SELECTION, (Object)this);
        }

        public static PosSelection readFromItemStack(ItemStack itemStack) {
            return (PosSelection)itemStack.getOrDefault(ModDataComponents.POS_SELECTION, (Object)EMPTY);
        }

        public static void updateItemStack(ItemStack itemStack, UnaryOperator<PosSelection> updater) {
            ((PosSelection)updater.apply(PosSelection.readFromItemStack(itemStack))).writeToItemStack(itemStack);
        }
    }
}

