/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blueprints.v1;

import com.ldtteam.structurize.api.BlockPosUtil;
import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.DataFixerUtils;
import com.ldtteam.structurize.blueprints.v1.DataVersion;
import com.ldtteam.structurize.tag.ModTags;
import com.mojang.serialization.Dynamic;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.fixes.ChunkPalettedStorageFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.BlockAttachedEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;

public class BlueprintUtil {
    public static final int DEFAULT_FIXER_IF_NOT_FOUND = DataVersion.v1_12_2.getDataVersion();
    public static final String NBT_OPTIONAL_DATA_TAG = "optional_data";

    public static Blueprint createBlueprint(Level world, BlockPos pos, boolean saveEntities, short sizeX, short sizeY, short sizeZ, String name, Optional<BlockPos> anchorPos) {
        BlockEntity tile;
        ArrayList<BlockState> pallete = new ArrayList<BlockState>();
        pallete.add(Blocks.AIR.defaultBlockState());
        short[][][] structure = new short[sizeY][sizeZ][sizeX];
        ArrayList<CompoundTag> tileEntities = new ArrayList<CompoundTag>();
        ArrayList<String> requiredMods = new ArrayList<String>();
        for (BlockPos mutablePos : BlockPos.betweenClosed((BlockPos)pos, (BlockPos)pos.offset(sizeX - 1, sizeY - 1, sizeZ - 1))) {
            LevelChunk chunk;
            BlockEntity te;
            BlockState state = world.getBlockState(mutablePos);
            if (state.is(ModTags.BLUEPRINT_BLACKLIST)) continue;
            String modName = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).getNamespace();
            short x = (short)(mutablePos.getX() - pos.getX());
            short y = (short)(mutablePos.getY() - pos.getY());
            short z = (short)(mutablePos.getZ() - pos.getZ());
            if (!modName.equals("minecraft") && !modName.equals("structurize")) {
                if (!ModList.get().getModContainerById(modName).isPresent()) {
                    structure[y][z][x] = (short)pallete.indexOf(Blocks.AIR.defaultBlockState());
                    continue;
                }
                if (!requiredMods.contains(modName)) {
                    requiredMods.add(modName);
                }
            }
            BlockEntity blockEntity = te = (chunk = world.getChunkAt(mutablePos)).getBlockEntities().containsKey(mutablePos) && !((BlockEntity)chunk.getBlockEntities().get(mutablePos)).isRemoved() ? chunk.getBlockEntity(mutablePos) : world.getBlockEntity(mutablePos.immutable());
            if (te != null) {
                CompoundTag teTag = te.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
                teTag.putShort("x", x);
                teTag.putShort("y", y);
                teTag.putShort("z", z);
                tileEntities.add(teTag);
            }
            if (!pallete.contains(state)) {
                pallete.add(state);
            }
            structure[y][z][x] = (short)pallete.indexOf(state);
        }
        CompoundTag[] tes = tileEntities.toArray(new CompoundTag[0]);
        ArrayList<CompoundTag> entitiesTag = new ArrayList<CompoundTag>();
        List entities = new ArrayList();
        if (saveEntities) {
            entities = world.getEntities(null, new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + sizeX), (double)(pos.getY() + sizeY), (double)(pos.getZ() + sizeZ)));
        }
        for (Entity entity : entities) {
            if (!entity.getType().canSerialize()) continue;
            Vec3 oldPos = entity.position();
            CompoundTag entityTag = new CompoundTag();
            entity.save(entityTag);
            ListTag posList = new ListTag();
            posList.add((Object)DoubleTag.valueOf((double)(oldPos.x - (double)pos.getX())));
            posList.add((Object)DoubleTag.valueOf((double)(oldPos.y - (double)pos.getY())));
            posList.add((Object)DoubleTag.valueOf((double)(oldPos.z - (double)pos.getZ())));
            if (entity instanceof BlockAttachedEntity) {
                BlockAttachedEntity attachedEntity = (BlockAttachedEntity)entity;
                BlockPos entityPos = attachedEntity.getPos();
                entityTag.put("TileX", (Tag)IntTag.valueOf((int)(entityPos.getX() - pos.getX())));
                entityTag.put("TileY", (Tag)IntTag.valueOf((int)(entityPos.getY() - pos.getY())));
                entityTag.put("TileZ", (Tag)IntTag.valueOf((int)(entityPos.getZ() - pos.getZ())));
            }
            entityTag.put("Pos", (Tag)posList);
            entitiesTag.add(entityTag);
        }
        Blueprint schem = new Blueprint(sizeX, sizeY, sizeZ, (short)pallete.size(), pallete, structure, tes, requiredMods, (HolderLookup.Provider)world.registryAccess());
        schem.setEntities(entitiesTag.toArray(new CompoundTag[0]));
        if (anchorPos.isPresent()) {
            BlockPos relativeAnchorPos = new BlockPos((Vec3i)anchorPos.get().subtract((Vec3i)pos));
            schem.setCachePrimaryOffset(relativeAnchorPos);
        }
        if ((tile = world.getBlockEntity(pos.offset((Vec3i)schem.getPrimaryBlockOffset()))) instanceof IBlueprintDataProviderBE) {
            CompoundTag blueprintData = (CompoundTag)schem.getBlockInfoAsMap().get(schem.getPrimaryBlockOffset()).getTileEntityData().get("blueprintDataProvider");
            if (name != null) {
                String fileName = FilenameUtils.getBaseName((String)name);
                blueprintData.putString("schematicName", fileName);
                ((IBlueprintDataProviderBE)tile).setSchematicName(fileName);
                ((IBlueprintDataProviderBE)tile).setBlueprintPath(name);
            }
            BlockPos corner1 = BlockPos.ZERO.subtract((Vec3i)schem.getPrimaryBlockOffset());
            BlockPos corner2 = new BlockPos(sizeX - 1, sizeY - 1, sizeZ - 1).subtract((Vec3i)schem.getPrimaryBlockOffset());
            ((IBlueprintDataProviderBE)tile).setSchematicCorners(corner1, corner2);
            BlockPosUtil.writeToNBT(blueprintData, "corner1", corner1);
            BlockPosUtil.writeToNBT(blueprintData, "corner2", corner2);
            if (!world.isClientSide) {
                ((ServerLevel)world).getChunkSource().blockChanged(pos);
            }
        }
        if (name != null) {
            schem.setName(name);
        }
        return schem;
    }

    public static CompoundTag writeBlueprintToNBT(Blueprint schem) {
        CompoundTag tag = new CompoundTag();
        tag.putByte("version", (byte)1);
        tag.putShort("size_x", (short)schem.getSizeX());
        tag.putShort("size_y", schem.getSizeY());
        tag.putShort("size_z", (short)schem.getSizeZ());
        BlockState[] palette = schem.getPalette();
        ListTag paletteTag = new ListTag();
        for (short i = 0; i < schem.getPalleteSize(); i = (short)(i + 1)) {
            paletteTag.add((Object)NbtUtils.writeBlockState((BlockState)palette[i]));
        }
        tag.put("palette", (Tag)paletteTag);
        int[] blockInt = BlueprintUtil.convertBlocksToSaveData(schem.getStructure(), schem.getSizeX(), schem.getSizeY(), schem.getSizeZ());
        tag.putIntArray("blocks", blockInt);
        ListTag finishedTes = new ListTag();
        CompoundTag[] tes = (CompoundTag[])Arrays.stream(schem.getTileEntities()).flatMap(Arrays::stream).flatMap(Arrays::stream).filter(Objects::nonNull).toArray(CompoundTag[]::new);
        finishedTes.addAll(Arrays.asList(tes));
        tag.put("tile_entities", (Tag)finishedTes);
        ListTag finishedEntities = new ListTag();
        CompoundTag[] entities = schem.getEntities();
        finishedEntities.addAll(Arrays.asList(entities));
        tag.put("entities", (Tag)finishedEntities);
        List<String> requiredMods = schem.getRequiredMods();
        ListTag modsList = new ListTag();
        for (String requiredMod : requiredMods) {
            modsList.add((Object)StringTag.valueOf((String)requiredMod));
        }
        tag.put("required_mods", (Tag)modsList);
        String name = schem.getName();
        String[] architects = schem.getArchitects();
        if (name != null) {
            tag.putString("name", name);
        }
        if (architects != null) {
            ListTag architectsTag = new ListTag();
            for (String architect : architects) {
                architectsTag.add((Object)StringTag.valueOf((String)architect));
            }
            tag.put("architects", (Tag)architectsTag);
        }
        tag.put("mcversion", (Tag)IntTag.valueOf((int)SharedConstants.getCurrentVersion().getDataVersion().getVersion()));
        CompoundTag optionalTag = new CompoundTag();
        CompoundTag structurizeTag = new CompoundTag();
        BlockPosUtil.writeToNBT(structurizeTag, "primary_offset", schem.getPrimaryBlockOffset());
        optionalTag.put("structurize", (Tag)structurizeTag);
        tag.put(NBT_OPTIONAL_DATA_TAG, (Tag)optionalTag);
        return tag;
    }

    public static List<BlockState> fixPalette(int oldDataVersion, ListTag paletteTag) {
        short paletteSize = (short)paletteTag.size();
        ArrayList<BlockState> palette = new ArrayList<BlockState>();
        for (short i = 0; i < paletteSize; i = (short)(i + 1)) {
            CompoundTag nbt = paletteTag.getCompound((int)i);
            try {
                CompoundTag fixedNbt = DataFixerUtils.runDataFixer(nbt, References.BLOCK_STATE, oldDataVersion);
                switch (oldDataVersion) {
                    case 1343: {
                        BlueprintUtil.fixPalette1343(fixedNbt);
                    }
                }
                BlockState state = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)fixedNbt);
                palette.add(i, state);
                continue;
            }
            catch (Exception e) {
                palette.add(i, Blocks.AIR.defaultBlockState());
                Log.getLogger().warn("Blueprint reader: something went wrong loading block at position: " + i, (Throwable)e);
            }
        }
        return palette;
    }

    private static void fixPalette1343(CompoundTag oldBlockState) {
        String name = oldBlockState.getString("Name");
        oldBlockState.putString("Name", oldBlockState.getString("Name").toLowerCase(Locale.US));
        if (name.contains("structurize")) {
            if (name.contains("blockshingle_")) {
                String[] split = name.split(":")[1].split("_");
                oldBlockState.putString("Name", "structurize:clay_" + (String)(split.length > 2 ? split[1] + "_" + split[2] : split[1]) + "_shingle");
            } else if (name.contains("blockshingleslab")) {
                oldBlockState.putString("Name", "structurize:clay_shingle_slab");
            } else if (name.contains("blocktimberframe")) {
                String[] split = name.split(":")[1].split("_");
                Object output = "structurize:" + (split.length > 3 ? split[3] : split[2]) + "_" + (String)(split.length > 3 ? split[1] + "_" + split[2] : split[1]) + "_paper_timber_frame";
                output = ((String)output).replace("doublecrossed", "double_crossed");
                output = ((String)output).replace("sideframed", "side_framed");
                output = ((String)output).replace("upgated", "up_gated");
                output = ((String)output).replace("downgated", "down_gated");
                output = ((String)output).replace("onecrossedlr", "one_crossed_lr");
                output = ((String)output).replace("onecrossedrl", "one_crossed_rl");
                output = ((String)output).replace("horizontalplain", "horizontal_plain");
                output = ((String)output).replace("sideframedhorizontal", "side_framed_horizontal");
                oldBlockState.putString("Name", (String)output);
            } else if (name.contains("blockpaperwall") && !name.contains("_")) {
                oldBlockState.putString("Name", "structurize:" + oldBlockState.getCompound("Properties").getString("variant") + "_blockpaperwall");
            }
        }
    }

    public static CompoundTag[] fixTileEntities(int oldDataVersion, ListTag tileEntitiesTag) {
        CompoundTag[] tileEntities = new CompoundTag[tileEntitiesTag.size()];
        for (short i = 0; i < tileEntities.length; i = (short)(i + 1)) {
            CompoundTag nbt = tileEntitiesTag.getCompound((int)i);
            try {
                String id = nbt.getString("id");
                if (id.contains("minecolonies")) {
                    nbt.putString("id", id.toLowerCase(Locale.US));
                    nbt.putString("Item", nbt.getString("Item".toLowerCase(Locale.US)));
                    tileEntities[i] = nbt;
                    continue;
                }
                if (id.equals("minecraft:flower_pot") || id.equals("minecraft:noteblock")) {
                    tileEntities[i] = nbt;
                    continue;
                }
                tileEntities[i] = id.startsWith("minecraft:") ? DataFixerUtils.runDataFixer(nbt, References.BLOCK_ENTITY, oldDataVersion) : nbt;
                continue;
            }
            catch (Exception e) {
                tileEntities[i] = null;
                Log.getLogger().warn("Blueprint reader: something went wrong loading tile entity at position: " + i, (Throwable)e);
            }
        }
        return tileEntities;
    }

    public static CompoundTag[] fixEntities(int oldDataVersion, ListTag entitiesTag) {
        CompoundTag[] entities = new CompoundTag[entitiesTag.size()];
        for (short i = 0; i < entities.length; i = (short)(i + 1)) {
            CompoundTag nbt = entitiesTag.getCompound((int)i);
            try {
                String id = nbt.getString("id");
                entities[i] = id.startsWith("minecraft:") ? DataFixerUtils.runDataFixer(nbt, References.ENTITY, oldDataVersion) : nbt;
                continue;
            }
            catch (Exception e) {
                entities[i] = null;
                Log.getLogger().warn("Blueprint reader: something went wrong loading entity at position: " + i, (Throwable)e);
            }
        }
        return entities;
    }

    private static List<BlockPos> searchForBlockIdInBlocks(short idToCheck, short[][][] blocks) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        for (int y = 0; y < blocks.length; y = (int)((short)(y + 1))) {
            short[][] temp = blocks[y];
            for (int z = 0; z < temp.length; z = (int)((short)(z + 1))) {
                short[] temp2 = temp[z];
                for (int x = 0; x < temp2.length; x = (int)((short)(x + 1))) {
                    short id = temp2[x];
                    if (id != idToCheck) continue;
                    result.add(new BlockPos(x, y, z));
                }
            }
        }
        return result;
    }

    private static Map<Integer, BlockPos> searchForTEposInTEs(List<BlockPos> blockPosToFind, CompoundTag[] tileEntities) {
        HashMap<Integer, BlockPos> result = new HashMap<Integer, BlockPos>();
        for (int i = 0; i < tileEntities.length; ++i) {
            BlockPos bp;
            CompoundTag compound = tileEntities[i];
            if (compound == null || !blockPosToFind.contains(bp = new BlockPos(compound.getInt("x"), compound.getInt("y"), compound.getInt("z")))) continue;
            result.put(i, bp);
        }
        return result;
    }

    private static void teToBlockStateFix(List<BlockState> palette, short[][][] blocks, CompoundTag[] tileEntities, short paletteIndex, Function<CompoundTag, CompoundTag> dataFixer) {
        Map<Integer, BlockPos> teToReplace = BlueprintUtil.searchForTEposInTEs(BlueprintUtil.searchForBlockIdInBlocks(paletteIndex, blocks), tileEntities);
        HashMap<BlockState, Short> newBlocksToBlockId = new HashMap<BlockState, Short>();
        boolean paletteFull = false;
        palette.set(paletteIndex, null);
        for (Map.Entry<Integer, BlockPos> e : teToReplace.entrySet()) {
            short newBlockId;
            CompoundTag teCompound = tileEntities[e.getKey()];
            tileEntities[e.getKey().intValue()] = null;
            CompoundTag newBScompound = dataFixer.apply(teCompound);
            BlockState newBlockState = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)newBScompound);
            short s = newBlockId = paletteFull ? newBlocksToBlockId.getOrDefault(newBlockState, (short)palette.size()) : paletteIndex;
            if (newBlockId == palette.size()) {
                palette.add(newBlockId, newBlockState);
                newBlocksToBlockId.put(newBlockState, newBlockId);
            } else if (!paletteFull) {
                palette.set(newBlockId, newBlockState);
                newBlocksToBlockId.put(newBlockState, newBlockId);
                paletteFull = true;
            }
            blocks[e.getValue().getY()][e.getValue().getZ()][e.getValue().getX()] = newBlockId;
        }
    }

    public static void fixCross1343(List<BlockState> palette, short[][][] blocks, CompoundTag[] tileEntities, CompoundTag[] entities) {
        short s = palette.size();
        for (short i = 0; i < s; i = (short)(i + 1)) {
            BlockState bs = palette.get(i);
            if (bs.getBlock() == Blocks.POTTED_CACTUS) {
                BlueprintUtil.teToBlockStateFix(palette, blocks, tileEntities, i, teCompound -> {
                    String type = teCompound.getString("Item") + teCompound.getInt("Data");
                    return (CompoundTag)ChunkPalettedStorageFix.FLOWER_POT_MAP.getOrDefault(type, (Dynamic)ChunkPalettedStorageFix.FLOWER_POT_MAP.get("minecraft:air0")).getValue();
                });
                continue;
            }
            if (bs.getBlock() != Blocks.NOTE_BLOCK) continue;
            BlueprintUtil.teToBlockStateFix(palette, blocks, tileEntities, i, teCompound -> {
                String type = Boolean.toString(teCompound.getBoolean("powered")) + (byte)Math.min(Math.max(teCompound.getInt("note"), 0), 24);
                return (CompoundTag)ChunkPalettedStorageFix.NOTE_BLOCK_MAP.getOrDefault(type, (Dynamic)ChunkPalettedStorageFix.NOTE_BLOCK_MAP.get("false0")).getValue();
            });
        }
    }

    public static Blueprint readBlueprintFromNBT(CompoundTag nbtTag, HolderLookup.Provider provider) {
        CompoundTag tag = nbtTag;
        byte version = tag.getByte("version");
        if (version == 1) {
            CompoundTag optionalTag;
            short sizeX = tag.getShort("size_x");
            short sizeY = tag.getShort("size_y");
            short sizeZ = tag.getShort("size_z");
            ArrayList<String> requiredMods = new ArrayList<String>();
            ArrayList<String> missingMods = new ArrayList<String>();
            ListTag modsList = (ListTag)tag.get("required_mods");
            int modListSize = modsList.size();
            for (int i = 0; i < modListSize; ++i) {
                requiredMods.add(modsList.get(i).getAsString());
                if (((String)requiredMods.get(i)).equals("minecraft") || ModList.get().getModContainerById((String)requiredMods.get(i)).isPresent()) continue;
                LogManager.getLogger().warn("Found missing mods for Blueprint, some blocks may be missing: " + (String)requiredMods.get(i));
                missingMods.add((String)requiredMods.get(i));
            }
            int oldDataVersion = tag.contains("mcversion") ? tag.getInt("mcversion") : DEFAULT_FIXER_IF_NOT_FOUND;
            ListTag paletteTag = (ListTag)tag.get("palette");
            List<BlockState> palette = BlueprintUtil.fixPalette(oldDataVersion, paletteTag);
            short[][][] blocks = BlueprintUtil.convertSaveDataToBlocks(tag.getIntArray("blocks"), sizeX, sizeY, sizeZ);
            CompoundTag[] tileEntities = BlueprintUtil.fixTileEntities(oldDataVersion, (ListTag)tag.get("tile_entities"));
            CompoundTag[] entities = BlueprintUtil.fixEntities(oldDataVersion, (ListTag)tag.get("entities"));
            if (oldDataVersion == DEFAULT_FIXER_IF_NOT_FOUND) {
                BlueprintUtil.fixCross1343(palette, blocks, tileEntities, entities);
            }
            Blueprint schem = new Blueprint(sizeX, sizeY, sizeZ, (short)palette.size(), palette, blocks, tileEntities, requiredMods, provider).setMissingMods(missingMods.toArray(new String[0]));
            schem.setEntities(entities);
            if (tag.getAllKeys().contains("name")) {
                schem.setName(tag.getString("name"));
            }
            if (tag.getAllKeys().contains("architects")) {
                ListTag architectsTag = (ListTag)tag.get("architects");
                String[] architects = new String[architectsTag.size()];
                for (int i = 0; i < architectsTag.size(); ++i) {
                    architects[i] = architectsTag.getString(i);
                }
                schem.setArchitects(architects);
            }
            if (tag.getAllKeys().contains(NBT_OPTIONAL_DATA_TAG) && (optionalTag = tag.getCompound(NBT_OPTIONAL_DATA_TAG)).getAllKeys().contains("structurize")) {
                CompoundTag structurizeTag = optionalTag.getCompound("structurize");
                BlockPos offsetPos = BlockPosUtil.readFromNBT(structurizeTag, "primary_offset");
                schem.setCachePrimaryOffset(offsetPos);
            }
            return schem;
        }
        return null;
    }

    public static void writeToStream(OutputStream os, Blueprint schem) {
        try {
            NbtIo.writeCompressed((CompoundTag)BlueprintUtil.writeBlueprintToNBT(schem), (OutputStream)os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int[] convertBlocksToSaveData(short[][][] multDimArray, int sizeX, int sizeY, int sizeZ) {
        int currentInt;
        short[] oneDimArray = new short[sizeX * sizeY * sizeZ];
        int j = 0;
        for (int y = 0; y < sizeY; y = (int)((short)(y + 1))) {
            for (int z = 0; z < sizeZ; z = (int)((short)(z + 1))) {
                for (int x = 0; x < sizeX; x = (int)((short)(x + 1))) {
                    oneDimArray[j++] = multDimArray[y][z][x];
                }
            }
        }
        int[] ints = new int[(int)Math.ceil((float)oneDimArray.length / 2.0f)];
        for (int i = 1; i < oneDimArray.length; i += 2) {
            currentInt = oneDimArray[i - 1];
            ints[(int)Math.ceil((double)((double)((float)i / 2.0f))) - 1] = currentInt = currentInt << 16 | oneDimArray[i];
        }
        if (oneDimArray.length % 2 == 1) {
            ints[ints.length - 1] = currentInt = oneDimArray[oneDimArray.length - 1] << 16;
        }
        return ints;
    }

    public static short[][][] convertSaveDataToBlocks(int[] ints, short sizeX, short sizeY, short sizeZ) {
        short[] oneDimArray = new short[ints.length * 2];
        for (int i = 0; i < ints.length; ++i) {
            oneDimArray[i * 2] = (short)(ints[i] >> 16);
            oneDimArray[i * 2 + 1] = (short)ints[i];
        }
        short[][][] multDimArray = new short[sizeY][sizeZ][sizeX];
        int i = 0;
        for (short y = 0; y < sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < sizeX; x = (short)(x + 1)) {
                    multDimArray[y][z][x] = oneDimArray[i++];
                }
            }
        }
        return multDimArray;
    }
}

