/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blockentities;

import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.blockentities.ModBlockEntities;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.component.CapturedBlock;
import com.ldtteam.structurize.component.ModDataComponents;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BlockEntityTagSubstitution
extends BlockEntity
implements IBlueprintDataProviderBE {
    public static final String CAPTURED_BLOCK_TAG = "captured_block";
    public static final String CAPTURED_BLOCK_TAG_OLD = "replacement";
    private String schematicName = "";
    private BlockPos corner1 = BlockPos.ZERO;
    private BlockPos corner2 = BlockPos.ZERO;
    private Map<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();
    private String packName;
    private String inPackPath;
    private CapturedBlock replacement = CapturedBlock.EMPTY;

    public BlockEntityTagSubstitution(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TAG_SUBSTITUTION.get(), pos, state);
    }

    @Override
    public String getSchematicName() {
        return this.schematicName;
    }

    @Override
    public void setSchematicName(String name) {
        this.schematicName = name;
    }

    @Override
    public Map<BlockPos, List<String>> getPositionedTags() {
        return this.tagPosMap;
    }

    @Override
    public void setPositionedTags(Map<BlockPos, List<String>> positionedTags) {
        this.tagPosMap = positionedTags;
        this.setChanged();
    }

    @Override
    public Tuple<BlockPos, BlockPos> getSchematicCorners() {
        if (this.corner1 == BlockPos.ZERO || this.corner2 == BlockPos.ZERO) {
            return new Tuple((Object)this.worldPosition, (Object)this.worldPosition);
        }
        return new Tuple((Object)this.corner1, (Object)this.corner2);
    }

    @Override
    public void setSchematicCorners(BlockPos pos1, BlockPos pos2) {
        this.corner1 = pos1;
        this.corner2 = pos2;
    }

    @Override
    public BlockPos getTilePos() {
        return this.worldPosition;
    }

    @NotNull
    public CapturedBlock getReplacement() {
        return this.replacement;
    }

    public void loadAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        RegistryOps dynamicOps = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        IBlueprintDataProviderBE.super.readSchematicDataFromNBT(compound);
        if (compound.contains(CAPTURED_BLOCK_TAG_OLD, 10)) {
            CompoundTag oldNbt = compound.getCompound(CAPTURED_BLOCK_TAG_OLD);
            this.replacement = new CapturedBlock(NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)oldNbt.getCompound("b")), Optional.of(oldNbt.getCompound("e")), oldNbt.contains("i") ? ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)oldNbt.getCompound("i")) : ItemStack.EMPTY);
        } else {
            this.replacement = BlockEntityTagSubstitution.deserializeReplacement(compound, (DynamicOps<Tag>)dynamicOps);
        }
    }

    public static CapturedBlock deserializeReplacement(CompoundTag compound, DynamicOps<Tag> dynamicOps) {
        if (compound.getCompound(CAPTURED_BLOCK_TAG).isEmpty()) {
            return CapturedBlock.EMPTY;
        }
        return CapturedBlock.CODEC.parse(dynamicOps, (Object)compound.get(CAPTURED_BLOCK_TAG)).resultOrPartial(error -> {
            Log.getLogger().error("Parsing {} with data {}: {}", (Object)ModBlockEntities.TAG_SUBSTITUTION.getRegisteredName(), (Object)compound, error);
            Log.getLogger().error("", (Throwable)new RuntimeException());
        }).orElse(CapturedBlock.EMPTY);
    }

    public void saveAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        RegistryOps dynamicOps = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        this.writeSchematicDataToNBT(compound);
        BlockEntityTagSubstitution.serializeReplacement(compound, (DynamicOps<Tag>)dynamicOps, this.replacement);
    }

    public static void serializeReplacement(CompoundTag compound, DynamicOps<Tag> dynamicOps, CapturedBlock replacement) {
        compound.put(CAPTURED_BLOCK_TAG, (Tag)CapturedBlock.CODEC.encodeStart(dynamicOps, (Object)replacement).getOrThrow());
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public void setPackName(String packName) {
        this.packName = packName;
    }

    @Override
    public void setBlueprintPath(String inPackPath) {
        this.inPackPath = inPackPath;
    }

    @Override
    public String getPackName() {
        return this.packName;
    }

    @Override
    public String getBlueprintPath() {
        return this.inPackPath;
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveCustomOnly(provider);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.replacement = (CapturedBlock)componentInput.getOrDefault(ModDataComponents.CAPTURED_BLOCK, (Object)CapturedBlock.EMPTY);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder componentBuilder) {
        super.collectImplicitComponents(componentBuilder);
        componentBuilder.set(ModDataComponents.CAPTURED_BLOCK, (Object)this.replacement);
    }

    public void removeComponentsFromTag(CompoundTag itemStackTag) {
        itemStackTag.remove(CAPTURED_BLOCK_TAG);
    }
}

