/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.content;

import com.hlysine.create_power_loader.content.AbstractChunkLoaderBlockEntity;
import com.hlysine.create_power_loader.content.LoaderType;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractChunkLoaderBlock
extends DirectionalKineticBlock {
    public static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;
    public final LoaderType loaderType;

    public AbstractChunkLoaderBlock(BlockBehaviour.Properties properties, LoaderType loaderType) {
        super(properties);
        this.loaderType = loaderType;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{ATTACHED}));
    }

    protected boolean shouldAttach(LevelAccessor level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite())).is((Block)AllBlocks.TRACK_STATION.get());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        for (Direction direction : Iterate.directions) {
            if (!context.getLevel().getBlockState(context.getClickedPos().relative(direction)).is((Block)AllBlocks.TRACK_STATION.get())) continue;
            state = (BlockState)state.setValue((Property)FACING, (Comparable)direction.getOpposite());
            break;
        }
        if (this.shouldAttach((LevelAccessor)context.getLevel(), context.getClickedPos(), state)) {
            state = (BlockState)state.setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    private void updateBEStation(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof AbstractChunkLoaderBlockEntity)) {
            return;
        }
        AbstractChunkLoaderBlockEntity clbe = (AbstractChunkLoaderBlockEntity)be;
        if (!((Boolean)state.getValue((Property)ATTACHED)).booleanValue()) {
            clbe.updateAttachedStation(null);
            return;
        }
        BlockEntity station = level.getBlockEntity(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()));
        if (!(station instanceof StationBlockEntity)) {
            return;
        }
        StationBlockEntity sbe = (StationBlockEntity)station;
        clbe.updateAttachedStation(sbe);
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        boolean shouldAttach;
        if (level.isClientSide) {
            return;
        }
        boolean attached = (Boolean)state.getValue((Property)ATTACHED);
        if (attached == (shouldAttach = this.shouldAttach((LevelAccessor)level, pos, state))) {
            return;
        }
        BlockState newState = (BlockState)state.cycle((Property)ATTACHED);
        level.setBlockAndUpdate(pos, newState);
        this.updateBEStation((LevelAccessor)level, pos, newState);
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pNeighborPos) {
        BlockState state = super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
        BlockState newState = (BlockState)state.setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(this.shouldAttach(pLevel, pCurrentPos, state)));
        this.updateBEStation(pLevel, pCurrentPos, newState);
        return newState;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return (Boolean)state.getValue((Property)ATTACHED) == false && face == ((Direction)state.getValue((Property)FACING)).getOpposite();
    }

    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return IRotate.SpeedLevel.MEDIUM;
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos) {
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be instanceof AbstractChunkLoaderBlockEntity) {
            AbstractChunkLoaderBlockEntity chunkLoader = (AbstractChunkLoaderBlockEntity)be;
            boolean attached = (Boolean)pState.getValue((Property)ATTACHED);
            return (attached ? chunkLoader.isLoaderActive : chunkLoader.canLoadChunks()) ? 15 : 0;
        }
        return 0;
    }
}

