/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.config.selector.BridgingAdjacency;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class Path {
    public static final double NEAR_ZERO = 0.01;
    public static final Vec3 CUBE_EXTENT = new Vec3(0.5, 0.5, 0.5);

    public static List<BlockPos> calculateBresenhamVoxels(BlockPos startPos, BlockPos endPos) {
        ArrayList<BlockPos> points = new ArrayList<BlockPos>();
        points.add(startPos);
        BlockPos delta = endPos.subtract((Vec3i)startPos);
        int dx = Math.abs(delta.getX());
        int dy = Math.abs(delta.getY());
        int dz = Math.abs(delta.getZ());
        int xStep = delta.getX() > 0 ? 1 : -1;
        int yStep = delta.getY() > 0 ? 1 : -1;
        int zStep = delta.getZ() > 0 ? 1 : -1;
        Vec3 workingVec = new Vec3((double)startPos.getX(), (double)startPos.getY(), (double)startPos.getZ());
        Vec3 targetVec = new Vec3((double)endPos.getX(), (double)endPos.getY(), (double)endPos.getZ());
        BridgingAdjacency adjacencySupported = BridgingMod.getConfig().getBridgingAdjacency();
        float extentMult = BridgingMod.getConfig().getBridgingSnapStrength();
        if (dx >= dy && dx >= dz) {
            int point1 = 2 * dy - dx;
            int point2 = 2 * dz - dx;
            while (Math.abs(workingVec.x() - targetVec.x()) > 0.01) {
                workingVec = workingVec.add((double)xStep, 0.0, 0.0);
                if (point1 >= 0) {
                    workingVec = workingVec.add(0.0, (double)yStep, 0.0);
                    point1 -= 2 * dx;
                }
                if (point2 >= 0) {
                    workingVec = workingVec.add(0.0, 0.0, (double)zStep);
                    point2 -= 2 * dx;
                }
                point1 += 2 * dy;
                point2 += 2 * dz;
                BlockPos newPoint = BlockPos.containing((Position)workingVec);
                if (adjacencySupported != BridgingAdjacency.DISABLED) {
                    List<BlockPos> lostPoints = Path.calculateMissedPoints(points, newPoint, startPos, endPos, extentMult, adjacencySupported);
                    points.addAll(lostPoints);
                }
                points.add(newPoint);
            }
            return points;
        }
        if (dy >= dx && dy >= dz) {
            int point1 = 2 * dx - dy;
            int point2 = 2 * dz - dy;
            while (Math.abs(workingVec.y() - targetVec.y()) > 0.01) {
                workingVec = workingVec.add(0.0, (double)yStep, 0.0);
                if (point1 >= 0) {
                    workingVec = workingVec.add((double)xStep, 0.0, 0.0);
                    point1 -= 2 * dy;
                }
                if (point2 >= 0) {
                    workingVec = workingVec.add(0.0, 0.0, (double)zStep);
                    point2 -= 2 * dy;
                }
                point1 += 2 * dx;
                point2 += 2 * dz;
                BlockPos newPoint = BlockPos.containing((Position)workingVec);
                if (adjacencySupported != BridgingAdjacency.DISABLED) {
                    List<BlockPos> lostPoints = Path.calculateMissedPoints(points, newPoint, startPos, endPos, extentMult, adjacencySupported);
                    points.addAll(lostPoints);
                }
                points.add(newPoint);
            }
            return points;
        }
        int point1 = 2 * dy - dz;
        int point2 = 2 * dx - dz;
        while (Math.abs(workingVec.z() - targetVec.z()) > 0.01) {
            workingVec = workingVec.add(0.0, 0.0, (double)zStep);
            if (point1 >= 0) {
                workingVec = workingVec.add(0.0, (double)yStep, 0.0);
                point1 -= 2 * dz;
            }
            if (point2 >= 0) {
                workingVec = workingVec.add((double)xStep, 0.0, 0.0);
                point2 -= 2 * dz;
            }
            point1 += 2 * dy;
            point2 += 2 * dx;
            BlockPos newPoint = BlockPos.containing((Position)workingVec);
            if (adjacencySupported != BridgingAdjacency.DISABLED) {
                List<BlockPos> lostPoints = Path.calculateMissedPoints(points, newPoint, startPos, endPos, extentMult, adjacencySupported);
                points.addAll(lostPoints);
            }
            points.add(newPoint);
        }
        return points;
    }

    private static List<BlockPos> calculateMissedPoints(List<BlockPos> points, BlockPos newPoint, BlockPos lineStart, BlockPos lineEnd, float extentMult, BridgingAdjacency maxAdjacency) {
        BlockPos checkPos;
        BlockPos[] checkDirections;
        if (points.isEmpty()) {
            return List.of();
        }
        BlockPos lastPoint = points.get(points.size() - 1);
        BlockPos pointDelta = newPoint.subtract((Vec3i)lastPoint);
        int diff = newPoint.distManhattan((Vec3i)lastPoint);
        if (diff < 0 || diff > 3) {
            throw new IllegalArgumentException("The last point and the new point share no common boundaries");
        }
        if (diff == 1 || diff == 0) {
            return List.of();
        }
        LinkedList<BlockPos> reviewPositions = new LinkedList<BlockPos>();
        if (diff == 2) {
            for (BlockPos direction : checkDirections = new BlockPos[]{new BlockPos(pointDelta.getX(), 0, 0), new BlockPos(0, pointDelta.getY(), 0), new BlockPos(0, 0, pointDelta.getZ())}) {
                if (direction.equals((Object)BlockPos.ZERO)) continue;
                checkPos = lastPoint.offset((Vec3i)direction);
                reviewPositions.add(checkPos);
            }
        }
        if (diff == 3) {
            for (BlockPos direction : checkDirections = new BlockPos[]{new BlockPos(pointDelta.getX(), 0, 0), new BlockPos(0, pointDelta.getY(), 0), new BlockPos(0, 0, pointDelta.getZ()), new BlockPos(pointDelta.getX(), pointDelta.getY(), 0), new BlockPos(pointDelta.getX(), 0, pointDelta.getZ()), new BlockPos(0, pointDelta.getY(), pointDelta.getZ())}) {
                if (direction.equals((Object)BlockPos.ZERO)) continue;
                checkPos = lastPoint.offset((Vec3i)direction);
                reviewPositions.add(checkPos);
            }
        }
        Vec3 newExtent = CUBE_EXTENT.scale((double)extentMult);
        return reviewPositions.stream().filter(pos -> {
            Vec3 boxSpaceTransform = Vec3.atLowerCornerOf((Vec3i)pos);
            Vec3 lineStartD = Vec3.atLowerCornerOf((Vec3i)lineStart).subtract(boxSpaceTransform);
            Vec3 lineEndD = Vec3.atLowerCornerOf((Vec3i)lineEnd).subtract(boxSpaceTransform);
            Vec3 lineMid = lineStartD.add(lineEndD).scale(0.5);
            Vec3 line = lineStartD.subtract(lineMid);
            Vec3 lineExt = new Vec3(Math.abs(line.x), Math.abs(line.y), Math.abs(line.z));
            if (Math.abs(lineMid.x) > newExtent.x + lineExt.x) {
                return false;
            }
            if (Math.abs(lineMid.y) > newExtent.y + lineExt.y) {
                return false;
            }
            if (Math.abs(lineMid.z) > newExtent.z + lineExt.z) {
                return false;
            }
            if (Math.abs(lineMid.y * line.z - lineMid.z * line.y) > newExtent.y * lineExt.z + newExtent.z * lineExt.y) {
                return false;
            }
            if (Math.abs(lineMid.x * line.z - lineMid.z * line.x) > newExtent.x * lineExt.z + newExtent.z * lineExt.x) {
                return false;
            }
            return !(Math.abs(lineMid.x * line.y - lineMid.y * line.x) > newExtent.x * lineExt.y + newExtent.y * lineExt.x);
        }).toList();
    }
}

