/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.block.plant.other.SaguaroCactusBlock;
import net.regions_unexplored.world.level.block.state.properties.SaguaroCactusShape;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class SaguaroCactusFeature
extends Feature<RuTreeConfiguration> {
    public SaguaroCactusFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.config();
        BlockPos pos = context.origin();
        RandomSource randomSource = context.random();
        WorldGenLevel level = context.level();
        int height_main = context.random().nextInt(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        BlockPos checkCactus = pos.above(3);
        if (level.getBlockState(checkCactus.north()).is(RuBlocks.SAGUARO_CACTUS.get()) || level.getBlockState(checkCactus.south()).is(RuBlocks.SAGUARO_CACTUS.get()) || level.getBlockState(checkCactus.east()).is(RuBlocks.SAGUARO_CACTUS.get()) || level.getBlockState(checkCactus.west()).is(RuBlocks.SAGUARO_CACTUS.get()) || level.getBlockState(checkCactus.north().east()).is(RuBlocks.SAGUARO_CACTUS.get()) || level.getBlockState(checkCactus.north().west()).is(RuBlocks.SAGUARO_CACTUS.get()) || level.getBlockState(checkCactus.south().east()).is(RuBlocks.SAGUARO_CACTUS.get()) || level.getBlockState(checkCactus.south().west()).is(RuBlocks.SAGUARO_CACTUS.get())) {
            return false;
        }
        BlockPos.MutableBlockPos checkPos = pos.mutable();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.move(Direction.UP);
        }
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            this.placeCactusBlock((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration, SaguaroCactusShape.UP_DOWN);
            if (placeCheck == 0) {
                this.placeRoot((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                this.placeLimbs((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            if (placeCheck == height_main) {
                this.placeChanceFlowerBlock((LevelAccessor)level, placePos.above(), randomSource, treeConfiguration);
            }
            placePos.move(Direction.UP);
        }
        return true;
    }

    public void placeLimbs(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        int bpx1 = randomSource.nextInt(2) + 3;
        int bpx2 = randomSource.nextInt(2) + 3;
        int bpx3 = randomSource.nextInt(2) + 3;
        int bpx4 = randomSource.nextInt(2) + 3;
        BlockPos newpos = new BlockPos(pos.getX() + 1, pos.getY() + bpx1, pos.getZ());
        BlockPos newpos1 = new BlockPos(pos.getX() - 1, pos.getY() + bpx2, pos.getZ());
        BlockPos newpos2 = new BlockPos(pos.getX(), pos.getY() + bpx3, pos.getZ() - 1);
        BlockPos newpos3 = new BlockPos(pos.getX(), pos.getY() + bpx4, pos.getZ() + 1);
        this.placeCactusBlock(level, newpos, randomSource, treeConfiguration, SaguaroCactusShape.EAST_WEST);
        this.placeCactusBlock(level, newpos.east(), randomSource, treeConfiguration, SaguaroCactusShape.WEST_UP);
        this.placeCactusBlock(level, newpos.east().above(), randomSource, treeConfiguration, SaguaroCactusShape.UP_DOWN);
        this.placeCactusBlock(level, newpos.east().above().above(), randomSource, treeConfiguration, SaguaroCactusShape.UP_DOWN);
        this.placeChanceFlowerBlock(level, newpos.east().above().above().above(), randomSource, treeConfiguration);
        this.placeCactusBlock(level, newpos1, randomSource, treeConfiguration, SaguaroCactusShape.EAST_WEST);
        this.placeCactusBlock(level, newpos1.west(), randomSource, treeConfiguration, SaguaroCactusShape.EAST_UP);
        this.placeCactusBlock(level, newpos1.west().above(), randomSource, treeConfiguration, SaguaroCactusShape.UP_DOWN);
        this.placeCactusBlock(level, newpos1.west().above().above(), randomSource, treeConfiguration, SaguaroCactusShape.UP_DOWN);
        this.placeChanceFlowerBlock(level, newpos1.west().above().above().above(), randomSource, treeConfiguration);
        this.placeCactusBlock(level, newpos2, randomSource, treeConfiguration, SaguaroCactusShape.NORTH_SOUTH);
        this.placeCactusBlock(level, newpos2.north(), randomSource, treeConfiguration, SaguaroCactusShape.SOUTH_UP);
        this.placeCactusBlock(level, newpos2.north().above(), randomSource, treeConfiguration, SaguaroCactusShape.UP_DOWN);
        this.placeCactusBlock(level, newpos2.north().above().above(), randomSource, treeConfiguration, SaguaroCactusShape.UP_DOWN);
        this.placeChanceFlowerBlock(level, newpos2.north().above().above().above(), randomSource, treeConfiguration);
        this.placeCactusBlock(level, newpos3, randomSource, treeConfiguration, SaguaroCactusShape.NORTH_SOUTH);
        this.placeCactusBlock(level, newpos3.south(), randomSource, treeConfiguration, SaguaroCactusShape.NORTH_UP);
        this.placeCactusBlock(level, newpos3.south().above(), randomSource, treeConfiguration, SaguaroCactusShape.UP_DOWN);
        this.placeCactusBlock(level, newpos3.south().above().above(), randomSource, treeConfiguration, SaguaroCactusShape.UP_DOWN);
        this.placeChanceFlowerBlock(level, newpos3.south().above().above().above(), randomSource, treeConfiguration);
    }

    public boolean placeCactusBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration, SaguaroCactusShape shape) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (SaguaroCactusFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.setBlock(pos, (BlockState)treeConfiguration.trunkProvider.getState(randomSource, pos).setValue(SaguaroCactusBlock.SHAPE, (Comparable)((Object)shape)), 2);
        } else {
            return true;
        }
        if (level.getBlockState(pos.below()).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        }
        return true;
    }

    public void placeRoot(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int rd = random.nextInt(2) + 4;
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int i = 0; i <= rd; ++i) {
            if (level.getBlockState((BlockPos)placePos).canBeReplaced() && level.getBlockState(placePos.above()).is(BlockTags.DIRT)) {
                level.setBlock((BlockPos)placePos, Blocks.HANGING_ROOTS.defaultBlockState(), 2);
                break;
            }
            if (!level.getBlockState((BlockPos)placePos).is(BlockTags.DIRT) && !level.getBlockState((BlockPos)placePos).is(BlockTags.REPLACEABLE_BY_TREES) && !level.isEmptyBlock((BlockPos)placePos)) break;
            this.placeCactusBlock(level, (BlockPos)placePos, randomSource, treeConfiguration, SaguaroCactusShape.UP_DOWN);
            placePos.move(Direction.DOWN);
        }
    }

    public boolean placeChanceFlowerBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).canBeReplaced() && randomSource.nextInt(4) == 0) {
            level.setBlock(pos, treeConfiguration.foliageProvider.getState(randomSource, pos), 2);
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return false;
        }
        return SaguaroCactusFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.is(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, SaguaroCactusFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.is(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, SaguaroCactusFeature::isReplaceableBlock);
    }
}

